% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lrt.glm.r
\name{lrt.glm}
\alias{lrt.glm}
\title{Computes a likelihood ratio test between a
reduced model and a full model. Both models must be already
fitted using and R function.}
\usage{
lrt.glm(modr, modf)
}
\arguments{
\item{modr}{is the object containing a previously fitted
reduced model, using a glm-type of function,  having less
parameters than modf.}

\item{modf}{is the object containing a previously fitted
full model, using a glm-type of function,  having more parameters
than modr.}
}
\value{
This function returns an object having the following
elements: "loglik.Modr" maximized log-likelihood of modr;
"loglik.Modf" maximized log-likelihood of modf;
"dif.loglik"  difference in log-likelihood between both models,
and "dif.df" difference in degrees of freedong of both models, and
"p-value" is the p-value for the LRT.
}
\description{
Computes a likelihood ratio test between a reduced model (modr)
and a full model (modr). Both models must be
previously fitted by maximum likelihood using an R function such
as nlme() and such, that are part of the generalized lineal
models.
}
\details{
Double-check the order of the reduced and full model,
before of using the model
}
\examples{

#not yet implemented
}
\references{
Pinheiro JC, and Bates DM. 2000. Mixed-effects models in S
and Splus. Springer-Verlag, New York, NY. 528 p.
}
\author{
Christian Salas-Eljatib.
}
