% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-co2temp.r
\docType{data}
\name{co2temp}
\alias{co2temp}
\title{CO2 emissions and temperature at country-level.}
\format{
The data contains 75 variables, and the fully
description can be reviewed in the references provided
here.
\describe{
\item{country}{Country.}
\item{year}{Calendar year.}
\item{iso_code}{TBA.}
\item{population}{Population size, in number of people.}
\item{gdp}{Gross domestic product, a measure of the value added created
through the production of goods and services in a country.}
\item{cement_co2}{TBA.}
\item{cement_co2_per_capita}{TBA.}
\item{co2}{TBA.}
\item{co2_growth_abs}{TBA.}
\item{co2_growth_prct}{TBA.}
\item{co2_including_luc}{TBA.}
\item{co2_including_luc_growth_abs}{TBA.}
\item{co2_including_luc_growth_prct}{TBA.}
\item{co2_including_luc_per_capita}{TBA.}
\item{co2_including_luc_per_gdp}{TBA.}
\item{co2_including_luc_per_unit_energy}{TBA.}
\item{co2_per_capita}{TBA.}
\item{co2_per_gdp}{TBA.}
\item{co2_per_unit_energy}{TBA.}
\item{coal_co2}{TBA.}
\item{coal_co2_per_capita}{TBA.}
\item{consumption_co2}{TBA.}
\item{consumption_co2_per_capita}{TBA.}
\item{consumption_co2_per_gdp}{TBA.}
\item{cumulative_cement_co2}{TBA.}
\item{cumulative_co2}{TBA.}
\item{cumulative_co2_including_luc}{TBA.}
\item{cumulative_coal_co2}{TBA.}
\item{cumulative_flaring_co2}{TBA.}
\item{cumulative_gas_co2}{TBA.}
\item{cumulative_luc_co2}{TBA.}
\item{cumulative_oil_co2}{TBA.}
\item{cumulative_other_co2}{TBA.}
\item{energy_per_capita}{TBA.}
\item{energy_per_gdp}{TBA.}
\item{flaring_co2}{TBA.}
\item{flaring_co2_per_capita}{TBA.}
\item{gas_co2}{TBA.}
\item{gas_co2_per_capita}{TBA.}
\item{ghg_excluding_lucf_per_capita}{TBA.}
\item{ghg_per_capita}{TBA.}
\item{land_use_change_co2}{TBA.}
\item{land_use_change_co2_per_capita}{TBA.}
\item{methane}{TBA.}
\item{methane_per_capita}{TBA.}
\item{nitrous_oxide}{TBA.}
\item{nitrous_oxide_per_capita}{TBA.}
\item{oil_co2}{TBA.}
\item{oil_co2_per_capita}{TBA.}
\item{primary_energy_consumption}{TBA.}
\item{share_global_cement_co2}{TBA.}
\item{share_global_co2}{TBA.}
\item{share_global_co2_including_luc}{TBA.}
\item{share_global_coal_co2}{TBA.}
\item{share_global_cumulative_cement_co2}{TBA.}
\item{share_global_cumulative_co2}{TBA.}
\item{share_global_cumulative_co2_including_luc}{TBA.}
\item{share_global_cumulative_coal_co2}{TBA.}
\item{share_global_cumulative_flaring_co2}{TBA.}
\item{share_global_cumulative_gas_co2}{TBA.}
\item{share_global_cumulative_luc_co2}{TBA.}
\item{share_global_cumulative_oil_co2}{TBA.}
\item{share_global_cumulative_other_co2}{TBA.}
\item{share_global_flaring_co2}{TBA.}
\item{share_global_gas_co2}{TBA.}
\item{share_global_luc_co2}{TBA.}
\item{share_global_oil_co2}{TBA.}
\item{share_global_other_co2}{TBA.}
\item{share_of_temperature_change_from_ghg}{TBA.}
\item{temperature_change_from_ch4}{TBA.}
\item{temperature_change_from_co2}{TBA.}
\item{temperature_change_from_ghg}{TBA.}
\item{temperature_change_from_n2o}{TBA.}
\item{total_ghg}{TBA.}
\item{total_ghg_excluding_lucf}{TBA.}
\item{trade_co2}{TBA.}
\item{trade_co2_share}{TBA.}
}
}
\source{
The data were obtained from the \eqn{hockeystick} library of R.
Notice that in the
dataframe only a portion of countries have been
kept.
}
\usage{
data(co2temp)
}
\description{
Data obtained from the \eqn{hockeystick} package, which
retrieves annual global carbon
dioxide emissions since 1750 from the World Data
repository https://github.com/owid/co2-data, as well as
other climate-related variables.
}
\examples{
data(co2temp)
names(co2temp)
table(co2temp$country)
lattice::xyplot(co2~year|country,data=co2temp,type="l",as.table=TRUE)
}
\references{
\itemize{
\item \url{https://www.globalcarbonproject.org/carbonbudget/}
\item Friedlingstein P. et al. 2020. Global Carbon Budget 2020,
Earth System Science Data 12:3269-3340 \doi{10.5194/essd-12-3269-2020}
}
}
\keyword{datasets}
