% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_incongruous.R
\name{check_incongruous}
\alias{check_incongruous}
\title{check_incongruous.R}
\usage{
check_incongruous(zMatrix, lfdrVec)
}
\arguments{
\item{zMatrix}{J*K vector of all test statistics.}

\item{lfdrVec}{J*1 vector of lfdr values corresponding to each set of test statistics.}
}
\value{
A vector with all the indices of all sets that have a higher lfdr value those a set
with smaller test statistic magnitudes.
}
\description{
Check the number of sets of test statistics that have a higher (less significant) lfdr value
than other sets with test statistics of uniformly smaller magnitudes.
}
\examples{
zMatrix <- cbind(rnorm(10^4), rnorm(10^4))
lfdrVec <- runif(10^4)
check_incongruous(zMatrix = zMatrix, lfdrVec = lfdrVec)

}
