% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand_modelframe.R
\name{expand_modelframe}
\alias{expand_modelframe}
\title{Expand covariate values choices and reference values varying one at a time}
\usage{
expand_modelframe(rv, covcol = "covname", ...)
}
\arguments{
\item{rv}{a data.frame with columns names of covariate(s) and values equal reference}

\item{covcol}{column name for the covariate being varied}

\item{...}{Arguments to be passed to methods}
}
\value{
A data.frame with combination of covariates
}
\description{
Expand covariate values choices and reference values varying one at a time
}
\examples{
reference.values <- data.frame(WT = 85, ALB = 45, SEX = 0)   
covcomb <- expand_modelframe(
  WT  = c(56, 72, 98, 128), # P05, P25, P75, P95 # ref is P50
ALB = c(40, 50),          # P05, P95 # ref is P50
  SEX = c(1),               # Reference is for SEX=0 (female)
  rv = reference.values)
covcomb
}
