% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_util.r
\name{logistic_tform}
\alias{logistic_tform}
\title{Logistic function to help set alpha opacity}
\usage{
logistic_tform(n, mid_pt = 600, k_attenuation = 5, ceiling = 1, floor = 0.3)
}
\arguments{
\item{n}{Number of observations to plot.}

\item{mid_pt}{Inflection point that the logistic curve. Defaults to 600.}

\item{k_attenuation}{The steepness of the transition, larger is a sharper
transition. Quite sensitive and defaults to 5.}

\item{ceiling}{The highest number returned. Defaults to 1.}

\item{floor}{The lowest number returned. Defaults to 0.3.}
}
\value{
A scalar numeric, suggested value to set alpha opacity.
}
\description{
Suggests a alpha opacity to plot with as a function of the number of
observation.
}
\examples{
library(cheem)

## Suggest an opacity to use in plotting:
(my_alpha <- logistic_tform(nrow(spinifex::penguins_na.rm)))

## Visualize
x <- 1:2000
plot(x, logistic_tform(x), col = "blue")
}
\seealso{
Other cheem utility: 
\code{\link{as_logical_index}()},
\code{\link{color_scale_of}()},
\code{\link{contains_nonnumeric}()},
\code{\link{is_discrete}()},
\code{\link{is_diverging}()},
\code{\link{linear_tform}()},
\code{\link{problem_type}()},
\code{\link{rnorm_from}()},
\code{\link{sug_basis}()},
\code{\link{sug_manip_var}()}
}
\concept{cheem utility}
