% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{gen_bkgnoise}
\alias{gen_bkgnoise}
\title{Generate Background Noise Data}
\usage{
gen_bkgnoise(n = 500, p = 4, m = rep(0, p), s = rep(2, p))
}
\arguments{
\item{n}{A numeric value (default: 500) representing the sample size.}

\item{p}{A numeric value (default: 4) representing the number of dimensions.}

\item{m}{A numeric vector (default: c(0, 0, 0, 0)) representing the mean along each dimensions.}

\item{s}{A numeric vector (default: c(2, 2, 2, 2)) representing the standard deviation along each dimensions.}
}
\value{
A data containing the generated background noise data.
}
\description{
This function generates background noise data with specified parameters such as
the number of samples, number of dimensions, mean, and standard deviation.
}
\examples{

# Generate background noise with custom mean and standard deviation
set.seed(20240412)
gen_bkgnoise(n = 500, p = 4, m = c(0, 0, 0, 0), s = c(2, 2, 2, 2))

}
