% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cTMed-methods-ctmedmed.R
\name{print.ctmedmed}
\alias{print.ctmedmed}
\title{Print Method for Object of Class \code{ctmedmed}}
\usage{
\method{print}{ctmedmed}(x, digits = 4, ...)
}
\arguments{
\item{x}{an object of class \code{ctmedmed}.}

\item{digits}{Integer indicating the number of decimal places to display.}

\item{...}{further arguments.}
}
\value{
Prints a matrix of effects.
}
\description{
Print Method for Object of Class \code{ctmedmed}
}
\examples{
phi <- matrix(
  data = c(
    -0.357, 0.771, -0.450,
    0.0, -0.511, 0.729,
    0, 0, -0.693
  ),
  nrow = 3
)
colnames(phi) <- rownames(phi) <- c("x", "m", "y")

# Specific time interval ----------------------------------------------------
med <- Med(
  phi = phi,
  delta_t = 1,
  from = "x",
  to = "y",
  med = "m"
)
print(med)

# Range of time intervals ---------------------------------------------------
med <- Med(
  phi = phi,
  delta_t = 1:5,
  from = "x",
  to = "y",
  med = "m"
)
print(med)

}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
