% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{weighted.quantile}
\alias{weighted.quantile}
\title{Weighted quantile estimator}
\usage{
weighted.quantile(x, probs, weights = NULL, type = "Harrell-Davis")
}
\arguments{
\item{x}{A numerical vector}

\item{probs}{Numerical vector of quantiles}

\item{weights}{A numerical vector with weights; should have the same length as x}

\item{type}{Type of estimator, can either be "inflation", "Harrell-Davis" using a beta function to
approximate the weighted percentiles (Harrell & Davis, 1982) or "Type7" (default; Hyndman & Fan, 1996), an adaption
of the generic quantile function in R, including weighting. The inflation procedure is essentially
a numerical, non-parametric solution that gives the same results as Harrel-Davis. It requires less
ressources with small datasets and always finds a solution (e. g. 1000 cases with
weights between 1 and 10). If it becomes too resource intense, it switches to Harrell-Davis automatically.
Harrel-Davis and Type7 code is based on the work of Akinshin (2023).}
}
\value{
the weighted quantiles
}
\description{
Computes weighted quantiles (code from Andrey Akinshin (2023) "Weighted quantile estimators" arXiv:2304.07265 [stat.ME]
Code made available via the CC BY-NC-SA 4.0 license) on the basis of either the weighted Harrell-Davis
quantile estimator or an adaption of the type 7 quantile estimator of the generic quantile function in
the base package. Please provide a vector with raw values, the probabilities for the quantiles and an
additional vector with the weight of each observation. In case the weight vector is NULL, a normal
quantile estimation is done. The vectors may not include NAs and the weights should be positive non-zero
values. Please draw on the computeWeights() function for retrieving weights in post stratification.
}
\references{
\enumerate{
  \item Harrell, F.E. & Davis, C.E. (1982). A new distribution-free quantile estimator. Biometrika, 69(3), 635-640.
  \item Hyndman, R. J. & Fan, Y. (1996). Sample quantiles in statistical packages, American Statistician 50, 361–365.
  \item Akinshin, A. (2023). Weighted quantile estimators arXiv:2304.07265 [stat.ME]
}
}
\seealso{
weighted.quantile.inflation, weighted.quantile.harrell.davis, weighted.quantile.type7
}
