% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootBraidModel.R
\name{calcBraidBootstrap}
\alias{calcBraidBootstrap}
\title{BRAID Parameter Confidence Intervals}
\usage{
calcBraidBootstrap(bfit, ciLevs = c(0.025, 0.975), numBoot = NULL)
}
\arguments{
\item{bfit}{A BRAID fit object of class \code{braidrm}.  If this object already
has bootstrapped coefficients, a warning will be given, and they will be
overwritten}

\item{ciLevs}{The lower and upper quantiles at which the confidence intervals
should be estimated.  Default is 0.025 and 0.975, producing 95\% confidence
intervals}

\item{numBoot}{The number of bootstrapped coefficient values to estimate.
Defaults to a  number large enough that at least 10 measurement should lie
outside the estimated interval; but held to a minimum value of 100 and a
maximum value of 1000.}
}
\value{
An object of class \code{braidrm} but with three additional elements:
\itemize{
\item \code{ciLevs}: The two quantiles at which the confidence intervals are set
\item \code{ciCoefs}: An array of bootstrapped coefficients.  The number of rows is
the number of \emph{successful} bootstrapped fits; there is one column for each
the nine BRAID parameters
\item \code{ciMat}: An array of confidence intervals on the fitted parameters. The
rows correspond to the \emph{free} parameters included in the fit, and are named
for those parameters; the firt column contains the lower bound of the
confidence intervals, the second column the upper bound.
}
}
\description{
Uses residuals-based bootstrapping to estimate confidence intervals on a
BRAID fit's response surface parameters
}
\examples{
bfit <- braidrm(measure ~ concA + concB, synergisticExample, getCIs = FALSE)
summary(bfit)

bfit_ci <- calcBraidBootstrap(bfit)
summary(bfit_ci)
}
