% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbn.sensitivity.R
\name{bbn.sensitivity}
\alias{bbn.sensitivity}
\title{Sensitivity Analysis for Bayesian Belief Network Models}
\usage{
bbn.sensitivity(bbn.model, boot_max = 1000, ...)
}
\arguments{
\item{bbn.model}{a matrix or dataframe of interactions between different model \code{nodes}.
One or more \code{nodes} (recommended no more than 3) which would be the main outcomes of interest in the model.
The spelling of these \code{nodes} needs to be identical (including capital letters) to that in the matrix or dataframe file.
(note, you should include spaces if these are in your matrix or dataframe file, rather than the dot notation used once imported into R).}

\item{boot_max}{The number of bootstraps to perform.
Suggested range for exploratory analysis 100-1000.
For final analysis recommended size = 1000 - 10000 - note, this can take a long time to run.
Default value is 1000.}

\item{...}{Key \code{nodes} for sensitivity analysis.
The function is designed to handle up to three key \code{nodes}, beyond which it recommends limiting the analysis for clarity and efficiency.}
}
\value{
The function outputs a plot showing the \code{nodes} most influential to the network's outcomes, alongside a table ranking these variables by their impact.
The analysis highlights how changes in the key \code{nodes} can affect the network, offering valuable insights for model refinement and decision-making.
}
\description{
\code{bbn.sensitivity()} conducts a sensitivity analysis on a Bayesian Belief Network (\code{BBN}) model.
It evaluates the impact of varying key \code{node} on the network's outcomes using \code{bootstrapping}.
The analysis helps identify which \code{node} significantly influence the network, providing insights into the robustness and dependency of the network's structure.
}
\examples{
data(my_BBN)
bbn.sensitivity(bbn.model = my_BBN, boot_max = 100, 'Limpet', 'Green Algae')

}
