% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aldvmm.gr.R
\name{aldvmm.gr}
\alias{aldvmm.gr}
\title{Calculating Numeric Gradients of the Negative Log-Likelihood}
\usage{
aldvmm.gr(par, X, y, psi, dist, ncmp, lcoef, lcmp, lcpar, optim.method)
}
\arguments{
\item{par}{a named numeric vector of parameter values.}

\item{X}{a list of design matrices returned by
\ifelse{html}{\code{\link[aldvmm]{aldvmm.mm}}}{\code{aldvmm.mm()}}.
\code{'X'} is of length 2 and includes a design matrix for the model of
component distributions and a design matrix for the model of probabilities
of group membership.}

\item{y}{a numeric vector of observed outcomes from complete observations in
\code{'data'} supplied to
\ifelse{html}{\code{\link[aldvmm]{aldvmm}}}{\code{aldvmm()}}.}

\item{psi}{a numeric vector of minimum and maximum possible utility values
smaller than or equal to 1 (e.g. \code{c(-0.594, 0.883)}). The potential
gap between the maximum value and 1 represents an area with zero density
in the value set from which utilities were obtained. The order of the
minimum and maximum limits in \code{'psi'} does not matter.}

\item{dist}{an optional character value of the distribution used in the
components. In this release, only the normal distribution is
available, and the default value is set to \code{"normal"}.}

\item{ncmp}{a numeric value of the number of components that are mixed. The
default value is 2. A value of 1 represents a tobit model with a gap
between 1 and the maximum value in \code{'psi'}.}

\item{lcoef}{a character vector of length 2 with labels of objects including
regression coefficients of component distributions (default \code{"beta"})
and coefficients of probabilities of component membership (default
\code{"delta"}).}

\item{lcmp}{a character value representing a stub (default \code{"Comp"})
for labeling objects including regression coefficients in different
components (e.g. "Comp1", "Comp2", ...). This label is also used in
summary tables returned by
\ifelse{html}{\code{\link[aldvmm]{summary.aldvmm}}}{\code{summary.aldvmm()}}.}

\item{lcpar}{a character vector with the labels of objects including
constant parameters of component distributions (e.g. the standard
deviation of the normal distribution). The length of \code{'lcpar'}
depends on the distribution supplied to \code{'dist'}.}

\item{optim.method}{an optional character value of one of the following
\ifelse{html}{\code{\link[optimx]{optimr}}}{\code{optimx::optimr()}}
methods: \code{"Nelder-Mead"}, \code{"BFGS"}, \code{"CG"},
\code{"L-BFGS-B"}, \code{"nlminb"}, \code{"Rcgmin"}, \code{"Rvmmin"} and
\code{"hjn"}. The default method is \code{"BFGS"}. The method
\code{"L-BFGS-B"} is used when lower and/or upper constraints are set
using \code{'init.lo'} and \code{'init.hi'}. The method \code{"nlm"}
cannot be used in the \code{'aldvmm'} package.}
}
\value{
a named numeric vector of first derivatives of the negative
  log-likelihood of the data with respect to parameters in \code{'par'}.
}
\description{
\ifelse{html}{\code{\link[aldvmm]{aldvmm.gr}}}{\code{aldvmm.gr()}}
calculates numerical gradients of the negative log-likelihood of the entire
estimation data with respect to parameter values in \code{'par'}.
}
\details{
\ifelse{html}{\code{\link[aldvmm]{aldvmm.gr}}}{\code{aldvmm.gr()}}
uses \ifelse{html}{\code{\link[aldvmm]{aldvmm.sc}}}{\code{aldvmm.sc()}} to
calculate analytical gradients of the negative log-likelihood.

If \code{'par'} includes infinite values 
\ifelse{html}{\code{\link[aldvmm]{aldvmm.gr}}}{\code{aldvmm.gr()}} returns a 
gradient of zero.
}
