% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot_Mundo.R
\name{Plot.Mundo}
\alias{Plot.Mundo}
\title{Cree un mapa dinámico y flexible para visualizar datos geográficos de países}
\usage{
Plot.Mundo(
  datos,
  paises,
  variable,
  grupo,
  tipo = c("Pais", "SiNoPais"),
  titulo,
  naTo0 = TRUE,
  colNA = "#EEEEEE",
  centroideMapa,
  zoomMapa = 2,
  baldosas,
  cortes,
  colores,
  opacidad = 0.7,
  colBorde,
  compacto = TRUE,
  textSize = 10,
  limpio = FALSE,
  estatico = FALSE,
  estilo
)
}
\arguments{
\item{datos}{Un data frame, no un vector numérico.}

\item{paises}{Una variable dentro del data frame ingresado en \code{datos}, que
contiene los códigos de los países, de acuerdo con la codificación
ISO3166, ya sea el nombre o el código alpha2 o alpha3.}

\item{variable}{Variable auxiliar con la cual se calculará el estadístico
previamente seleccionado. Para el caso en que la estadística a calcular sea
el conteo no es necesario (\emph{no se usará}) especificar dicha variable numérica.}

\item{grupo}{Variable auxiliar con la cual se segmentará los datos, para que
se grafique en un único plot divido en parcelas por dicha variable.}

\item{tipo}{Cadena de caracteres que indica el tipo de mapa a graficar. Los
valores permitidos son "Deptos", "SiNoMpios", "Mpios" y "DeptoMpio"
(\emph{valor predeterminado}). Se emparejará parcialmente.}

\item{titulo}{Cadena de caracteres indicando la segregación que presenta el
mapa y el periodo al que hace referencia éste, separados por un espacio, por
ejemplo, "Admitidos 2021-I".}

\item{naTo0}{Si es \code{TRUE} (\emph{valor predeterminado}) los valores introducidos
como \code{NA} (\emph{not available}) se cambiarán por el valor de 0. Ajústelo a \code{FALSE}
para que no se realice tal cambio y mostrar en la caja de información la
leyenda "Sin Información".}

\item{colNA}{Cadena de caracteres indicando el color que tendrá la categoría
\code{NA} (\emph{si esta se presenta}). El valor por defecto es un gris muy claro.}

\item{centroideMapa}{Cadena de caracteres indicando el país que servirá de
centroide al momento de graficar el mapa. El valor por defecto es "MEXICO".
Se emparejará parcialmente.}

\item{zoomMapa}{Valor numérico que indica el nivel de zoom del mapa
(\emph{usado por la función} \link[leaflet:map-methods]{setView()}). El valor por
defecto es \code{6}, entre mayor sea su valor más zoom se aplicará al mapa.}

\item{baldosas}{Vector de caracteres indicando los mapas base con los que se
realizará el mapa, sean los popularizados por Google Maps o por terceros.
Los valores aceptados son los admitidos por la función
\link[leaflet:addProviderTiles]{addProviderTiles()}, así mismo los valores por
defecto son \code{c("CartoDB.Positron", "Esri.WorldStreetMap", "Esri.NatGeoWorldMap")},
algunos otros valores pueden ser:
\itemize{
\item "Esri.DeLorme"
\item "Esri.WorldTerrain"
\item "Esri.WorldShadedRelief"
\item "Esri.WorldPhysical"
\item "Esri.OceanBasemap"
\item "Esri.WorldGrayCanvas"
\item "Esri.WorldImagery"
\item "Stamen.Toner"
\item "Stamen.TonerLite"
\item "Stamen.TonerLines"
\item "Stamen.Watercolor"
\item "Stamen.TonerHybrid"
}

La lista completa la puede consultar \href{http://leaflet-extras.github.io/leaflet-providers/preview/index.html}{aquí}}

\item{cortes}{Vector numérico indicando los cortes con los cuales se crearán
los intervalos. No aplica para el tipo de mapa "SiNoMpios", pues este es
binario. Para el tipo de mapa "DeptoMpio" se debe pasar una lista de la
siguiente manera \code{list(Deptos = c(), Mpios = c())}, pues requiere dos cortes,
uno para departamentos y otro para municipios.}

\item{colores}{Vector de caracteres indicando los colores para cada uno de los
intervalos con los que cuenta el mapa. Si no se introduce algún vector, se
usará una paleta predeterminada dependiendo del tipo de mapa.}

\item{opacidad}{Un número entre \eqn{[0, 1]} que indica la opacidad de las capas.}

\item{colBorde}{Cadena de caracteres indicando el color del borde de los
polígonos al momento de pasar el cursor sobre él.}

\item{compacto}{Si es \code{TRUE} (\emph{valor predeterminado}) el control de capas se
representará como un icono que se expande cuando se coloca el cursor sobre
él. Ajústelo a \code{FALSE} para que el control de capas siempre aparezca en su
estado expandido.}

\item{textSize}{Valor numérico que indica el tamaño del texto de las etiquetas
de los municipios. El valor para los departamentos será \eqn{+2px}.}

\item{limpio}{Si es \code{FALSE} (\emph{valor predeterminado}) se mostrará el MiniMapa,
la barra de escala y los botones para ver en pantalla completa, retornar zoom
y localización. Ajústelo a \code{TRUE} si desea omitir dichas herramientas adicionales
al mapa.}

\item{estatico}{Si es \code{FALSE} (\emph{valor predeterminado}) el gráfico a retornar
será dinámico (\emph{dependiendo de la librería seleccionada}), en caso contrario
se retornará un gráfico estático construido con \code{ggplot2}.}

\item{estilo}{Lista compuesta por varios parámetros, los cuales van a ser usados
para graficar el mapa \strong{estático} y cuyo objetivo es personalizar pequeños
detalles de éste.
\itemize{
\item \code{anchoBorde}: Número decimal que indica el ancho de la línea de contorno
de los polígonos del mapa. El valor por defecto es \code{0.5}.
\item \code{labelX}, \code{labelY}: Cadena de caracteres indicando la etiqueta del eje
respectivo. El valor por defecto es \code{"Longitud"} y \code{"Latitud"} respectivamente.
\item \code{xlim}, \code{ylim}: Vector numérico que especifica los límites de los ejes respectivos.
\item \code{Legend}: Igual uso que \code{gg.Legend} en \code{\link[=Plot.Series]{Plot.Series()}}
\item \code{Labs}: Igual uso que \code{gg.Texto} en \code{\link[=Plot.Series]{Plot.Series()}}. Con la adición del
argumento \code{fill}, el cual especifica el título de leyenda. El valor por
defecto es \code{"Statistic"}. Si es \code{NULL}, se omitirá dicho título.
\item \code{Theme}: Igual uso que \code{gg.Tema} en \code{\link[=Plot.Series]{Plot.Series()}}
\item \code{Style}: Cadena de caracteres que indica el tipo de mapa a graficar.
Los valores permitidos son \code{"Intervalo"}, \code{"SiNo"}, \code{"Calor"} y \code{NA}
(\emph{valor predeterminado}). Se emparejará parcialmente.
\item \code{Text}: Lista que especifica aspectos como el color y tamaño de los títulos
de los polígonos. Para más información, consulte la función \link[ggplot2:ggsf]{geom_sf_text()}.
\item \code{scaleX}, \code{scaleY}: Vector numérico que especifica los puntos o cortes a
graficar en dicho eje. Sacado de la función \link[ggplot2:scale_continuous]{scale_x_continuous()}.
}}
}
\value{
Retorna el mapa (\emph{objeto widget de HTML}) creado mediante \code{Leaflet}, el cual
pertenece a la clase "leaflet" y "htmlwidget".
}
\description{
Esta función está planeada para facilitar la creación de mapas interactivos
compatible con plataformas móviles y de escritorio, además de estar diseñada
pensando en la simplicidad y el rendimiento. Esta utilidad produce mapas que
tienen controles para hacer zoom, desplazarse y alternar capas y puntos entre
mostrar y ocultar. Igualmente, permite incrustar mapas en webs, documentos
\verb{R Markdown} y aplicaciones \code{Shiny}. Todo lo anterior basado enteramente en la
librería \code{Leaflet}, la cual es la biblioteca \code{JavaScript} de código abierto más
popular para mapas interactivos.
}
\examples{
LATAM <- data.frame(
  Country = c("Chile", "Venezuela", "Colombia", "Argentina", "Brazil"),
  PIB = c(1, 10, 100, 1000, 10000)*1:5
)
Plot.Mundo(
  datos    = LATAM,
  paises   = Country,
  variable = PIB,
  tipo     = "Pais",
  titulo   = "PIB 2023-Q1",
  naTo0    = FALSE,
  colNA    = "#3DBC25",
  centroideMapa = "Peru",
  zoomMapa = 3,
  cortes   = c(0, 10, 100, 1000, 10000, Inf),
  colores  = c("#DFA86A", "#FFBB00", "#FF5100", "#F20034", "#76009D"),
  opacidad = 0.5,
  colBorde = "#0E9BEE",
  compacto = TRUE,
  textSize = 4,
  limpio   = FALSE
)
\dontshow{if (all(FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# ---------------------------------------------------------------------------
set.seed(123)
LATAM <- data.frame(
  Pais = c("Bolivia", "Colombia", "Ecuador", "Panama", "Venezuela",
           "Peru", "Argentina", "Brazil", "Chile", "Uruguay"),
  PIB  = runif(10, -10, 10),
  Bolivariano = c("Sí", "Sí", "Sí", "Sí", "Sí", "Sí", "No", "No", "No", "No")
)
Plot.Mundo(
  datos    = LATAM,
  paises   = Pais,
  variable = Bolivariano,
  tipo     = "Pais",
  titulo   = "PA\u00cdSES BOLIVARIANOS EN AM\u00c9RICA LATINA",
  naTo0    = FALSE,
  estatico = TRUE,
  estilo   = list(Style = NA, Theme = 2)
)
# ---------------------------------------------------------------------------
Plot.Mundo(
  datos    = LATAM,
  paises   = Country,
  variable = PIB,
  tipo     = "SiNoPais",
  titulo   = "PIB 2023-Q1",
  centroideMapa = "Senegal",
  colores  = c("#45C9FF", "#FF153F"),
  opacidad = 0.6,
  colBorde = "#3DBC25",
  compacto = FALSE,
  textSize = 10,
  limpio   = FALSE
)
# ---------------------------------------------------------------------------
Plot.Mundo(
  datos    = LATAM,
  paises   = Pais,
  variable = PIB,
  # grupo  = Bolivariano,
  tipo     = "Pais",
  titulo   = "PROYECCI\u00d3N DEL PIB",
  opacidad = 0.4,
  colBorde = "#876445",
  estatico = TRUE,
  estilo   = list(
    Style = "Calor",
    showISO    = list(color = "#00468A", size = 3.5, fontface = "bold.italic"),
    xlim       = c(-82, -34),
    ylim       = c(-60, 14),
    scaleX     = seq(-82, 34, by = 8),
    scaleY     = seq(-60, 14, by = 5),
    anchoBorde = 1,
    Theme = 6, Legend = list(legend.position = "bottom", legend.direction = "horizontal"),
    Labs = list(subtitle = "Para Suram\u00e9rica en el 2023",
                caption  = "Datos simulados para el ejemplo ilustrativo",
                tag = "\u00ae"
                )
  )
)
# ---------------------------------------------------------------------------
Territories <- data.frame(
  Country = c("RUS", "FRA", "UKR", "ESP", "SWE", "DEU", "DZA", "COD", "SDN", "LBY", "TCD", "NER"),
  Area    = rep(10^(5:0), 2)
)
Plot.Mundo(
  datos    = Territories,
  paises   = Country,
  variable = Area,
  tipo     = "Pais",
  titulo   = "ALGUNOS DE LOS PA\u00cdSES CON MAYOR \u00c1REA",
  # showISO    = list(),
  naTo0    = FALSE,
  colNA    = "#0C1C2B",
  cortes   = c(-.0001, 10, 100, 1000, 10000, Inf),
  colores  = c("#DFA86A", "#FFBB00", "#FF5100", "#F20034", "#76009D"),
  opacidad = 0.4,
  limpio   = TRUE,
  estatico = TRUE,
  estilo   = list(
    Style = "Intervalo", continente = c("Africa", "Europe"), Theme = 4
  )
)
# ---------------------------------------------------------------------------
COL <- data.frame(Pais = "CO", IDH = 100000)
Plot.Mundo(
  datos    = COL,
  paises   = Pais,
  variable = IDH,
  tipo     = "Pais",
  titulo   = "",
  colores  = c("#10F235", "#00BCB5"),
  naTo0    = TRUE,
  estatico = TRUE,
  estilo   = list(Style = "SiNo", Theme = 3)
)
\dontshow{\}) # examplesIf}
}
