% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_information.R
\name{TreesMatchingTree}
\alias{TreesMatchingTree}
\alias{LnTreesMatchingTree}
\alias{Log2TreesMatchingTree}
\title{Number of trees containing a tree}
\usage{
TreesMatchingTree(tree)

LnTreesMatchingTree(tree)

Log2TreesMatchingTree(tree)
}
\arguments{
\item{tree}{A tree of class \code{\link[ape:read.tree]{phylo}}.}
}
\value{
\code{TreesMatchingTree()} returns a numeric specifying the number of
unrooted binary trees that contain all the edges present in the input tree.

\code{LnTreesMatchingTree()} gives the natural logarithm of this number.
}
\description{
\code{TreesMatchingTree()} calculates the number of unrooted binary trees that
are consistent with a tree topology on the same leaves.
}
\details{
Remember to unroot a tree first if the position of its root is arbitrary.
}
\examples{
partiallyResolvedTree <- CollapseNode(BalancedTree(8), 12:15)
TreesMatchingTree(partiallyResolvedTree)
LnTreesMatchingTree(partiallyResolvedTree)

# Number of rooted trees:
rootedTree <- AddTip(partiallyResolvedTree, where = 0)
TreesMatchingTree(partiallyResolvedTree)
}
\seealso{
Other tree information functions: 
\code{\link{CladisticInfo}()},
\code{\link{NRooted}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree information functions}
