% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hwsd.R
\name{get_hwsd2}
\alias{get_hwsd2}
\title{Get HWSD v2 Soil Data for a Given Location(s)}
\usage{
get_hwsd2(df, con, x = "longitude", y = "latitude", sequence = 1, layer = "D1")
}
\arguments{
\item{df}{A data frame containing location information, including longitude and latitude in decimal degrees.}

\item{con}{The HWSDv2 object returned by the \code{ini_hwsd2()} function, containing the raster and SQLite connection.}

\item{x}{The column name in the data frame representing longitude (default is 'Longitude').}

\item{y}{The column name in the data frame representing latitude (default is 'Latitude').}

\item{sequence}{Integer indicating the soil unit's dominance order within the SMU (default is 1 for the dominant soil). 
Valid values range from 1 to 12.}

\item{layer}{String indicating the depth layer for which soil attributes should be retrieved (default is 'D1', with layers ranging from 'D1' to 'D7').}
}
\value{
A data frame with the original location data augmented by soil attributes for the specified sequence and layer. 
The data frame includes additional columns such as `smu_id`, `SEQUENCE`, `LAYER`, and other soil attributes.
}
\description{
Queries the HWSD v2 database to retrieve soil information for specific locations based on their coordinates.
For each location, the function extracts the Soil Mapping Unit (SMU) code and retrieves soil attributes based 
on the specified sequence (soil dominance) and depth layer. The function returns the input data frame augmented 
with soil data from the HWSDv2 dataset.

The HWSD2_SMU table contains general information for each of the soil units 
occurring in any given SMU code (dominant soil unit and up to 11 associated soils).

The SEQUENCE column refers to the sequence in which soil units within the SMU 
are presented (in order of percentage share). The dominant soil has sequence 1. 
The sequence can range between 1 and 12.

The SHARE column refers to the share of the soil unit within the mapping unit in 
percentage. Shares of soil units within a mapping unit always sum up to 100 percent.

The HWSD2_LAYERS table provides soil attributes per depth layer for each of the 
seven depth layers (D1 to D7) separately (represented in the LAYER column in the 
HWSD2_LAYERS table). The depth of the top and bottom of each layer is defined in
the TOPDEP and BOTDEP columns, respectively.
}
\examples{
if (interactive()) {
  Location  <- c('Tel-Hadya', 'Terbol', 'Marchouch')
  Latitude  <- c(36.016, 33.808, 33.616)
  Longitude <- c(36.943, 35.991, -6.716)
  sites     <- data.frame(Location, Latitude, Longitude)
  
  hwsd2 <- ini_hwsd2(data_path = 'C:/Users/Kel-shamaa/Downloads/HWSD v2/')
  sites <- get_hwsd2(df = sites, con = hwsd2, x = 'Longitude', y = 'Latitude', 
                     sequence = 1, layer = 'D1')
}

}
\seealso{
\code{\link{ini_hwsd2}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
