% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_vis_sample.R
\name{boxplot_lr_group_comparison}
\alias{boxplot_lr_group_comparison}
\title{Boxplot Comparison of Ligand-Receptor Interaction Scores Across Groups}
\usage{
boxplot_lr_group_comparison(
  lr_scores,
  metadata,
  ligand,
  receptor,
  sender,
  receiver,
  group_by,
  score = c("normalized", "raw"),
  test = TRUE,
  paired = FALSE,
  test_method = c("wilcox.test", "t.test"),
  colors = c("#5fa9d1", "#154778"),
  title = NULL
)
}
\arguments{
\item{lr_scores}{Data frame containing LR interaction scores per sample (data frame).}

\item{metadata}{Data frame containing sample metadata (data frame).}

\item{ligand}{Ligand gene name to filter (character).}

\item{receptor}{Receptor gene name to filter (character).}

\item{sender}{Sender cell type to filter (character).}

\item{receiver}{Receiver cell type to filter (character).}

\item{group_by}{Column name in \code{metadata} to group samples (character).}

\item{score}{Use 'normalized' or 'raw' score (default: "normalized") (character).}

\item{test}{Whether to add a statistical test annotation (logical, default: TRUE).}

\item{paired}{Whether to treat the comparison as paired (logical, default: FALSE).}

\item{test_method}{Statistical test to use: "t.test" or "wilcox.test" (default = "wilcox.test") (character).}

\item{colors}{Vector of colors for groups (default: c("#5fa9d1", "#154778")).}

\item{title}{Custom plot title (optional).}
}
\value{
A list containing:
\itemize{
\item plot - ggplot object of the boxplot
\item df - data frame used for plotting
}
}
\description{
Generates  a boxplot comparing LR (ligand-receptor) interaction scores across sample groups.
with optional significance testing (t-test or Wilcoxon).
}
\examples{
# Boxplot of LR Score by group
data(lr_scores_eg)
data(metadata_eg)
res <- boxplot_lr_group_comparison(
  lr_scores_eg, metadata_eg,
  ligand = "TAC4", receptor = "TACR1",
  sender = "Perivascular", receiver = "Cardiac",
  group_by = "IFN_type", score = "normalized"
)

print(res$plot)
head(res$df)
}
