% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DisplayTreatment.R
\name{DisplayTreatment}
\alias{DisplayTreatment}
\title{Visualize the treatment distribution across units and time in a panel data set}
\usage{
DisplayTreatment(
  panel.data,
  color.of.treated = "red",
  color.of.untreated = "blue",
  title = "Treatment Distribution \\n Across Units and Time",
  xlab = "Time",
  ylab = "Unit",
  x.size = NULL,
  y.size = NULL,
  legend.position = "none",
  x.angle = NULL,
  y.angle = NULL,
  legend.labels = c("not treated", "treated"),
  decreasing = FALSE,
  matched.set = NULL,
  show.set.only = FALSE,
  hide.x.tick.label = FALSE,
  hide.y.tick.label = FALSE,
  gradient.weights = FALSE,
  dense.plot = FALSE
)
}
\arguments{
\item{panel.data}{\code{PanelData} object}

\item{color.of.treated}{Color of the treated observations provided as a character string (this includes hex values). Default is red.}

\item{color.of.untreated}{Color of the untreated observations provided as a character string (this includes hex values). Default is blue.}

\item{title}{Title of the plot provided as character string}

\item{xlab}{Character label of the x-axis}

\item{ylab}{Character label of the y-axis}

\item{x.size}{Numeric size of the text for xlab or x axis tick labels. Assign x.size = NULL to use built in ggplot2 method of determining label size. 
When the length of the time period is long, consider setting to NULL and adjusting size and ratio of the plot.}

\item{y.size}{Numeric size of the text for ylab or y axis tick labels. Assign y.size = NULL to use built in ggplot2 method of determining label size. 
When the number of units is large, consider setting to NULL and adjusting size and ratio of the plot.}

\item{legend.position}{Position of the legend. Provide this according to ggplot2 standards.}

\item{x.angle}{Angle (in degrees) of the tick labels for x-axis}

\item{y.angle}{Angle (in degrees) of the tick labels for y-axis}

\item{legend.labels}{Character vector of length two describing the
labels of the legend to be shown in the plot. ggplot2 standards are used.}

\item{decreasing}{Logical. Determines if display order should be increasing or decreasing by the amount of treatment received. Default is \code{decreasing} = FALSE.}

\item{matched.set}{(optional) a \code{matched.set} object containing a single treated unit and a set of matched controls. If provided, this set will be highlighted on the resulting plot.}

\item{show.set.only}{(optional) logical. If TRUE, only the treated unit and control units contained in the provided \code{matched.set} object will be shown on the plot. 
Default is FALSE. If no \code{matched.set} is provided, then this argument will have no effect.}

\item{hide.x.tick.label}{logical. If TRUE, x axis tick labels are not shown. Default is FALSE.}

\item{hide.y.tick.label}{logical. If TRUE, y axis tick labels are not shown. Default is FALSE.}

\item{gradient.weights}{(optional) logical. If TRUE, the "darkness"/shade of units in the provided \code{matched.set} object will be displayed according to their weight. Control units with higher weights will appear darker on the resulting plot. Control units with lower weights will appear lighter. This argument has no effect unless a \code{matched.set} is provided.}

\item{dense.plot}{logical. if TRUE, lines between tiles are removed on resulting plot. This is useful for producing more readable plots in situations where the number of units and/or time periods is very high.}
}
\value{
\code{DisplayTreatment} returns a treatment variation plot (generated via ggplot2 geom_tile() or geom_raster()),
which visualizes the variation of treatment across units and time. The results can be customized using ggplot2 syntax.
}
\description{
Visualize the treatment distribution across units and time in a panel data set
}
\examples{
dem.panel <- PanelData(panel.data = dem, 
              unit.id = "wbcode2", 
              time.id = "year", 
              treatment = "dem", 
              outcome = "y")
DisplayTreatment(panel.data = dem.panel,
                 legend.position = "none",
                 xlab = "year", ylab = "Country Code")


}
\author{
In Song Kim <insong@mit.edu>, Erik Wang
<haixiao@Princeton.edu>, Adam Rauh <amrauh@umich.edu>, and Kosuke Imai <imai@harvard.edu>
}
