% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_SMOTE_DMUs.R
\name{get_SMOTE_DMUs}
\alias{get_SMOTE_DMUs}
\title{Create New SMOTE Units to Balance Data combinations of m + s}
\usage{
get_SMOTE_DMUs(data, facets, x, y, RTS = "vrs", balance_data = NULL, seed)
}
\arguments{
\item{data}{A \code{list} of \code{data.frames}, where each element represents a dataset with labeled data.}

\item{facets}{A \code{list} where each element represents a subgroup containing index combinations that generate efficient units.}

\item{x}{Column indexes of the input variables in the \code{data}.}

\item{y}{Column indexes of the output variables in the \code{data}.}

\item{RTS}{Text string or number defining the underlying DEA technology /
returns-to-scale assumption (default: \code{"vrs"}). Accepted values:
\describe{
\item{\code{0} / \code{"fdh"}}{Free disposability hull, no convexity assumption.}
\item{\code{1} / \code{"vrs"}}{Variable returns to scale, convexity and free disposability.}
\item{\code{2} / \code{"drs"}}{Decreasing returns to scale, convexity, down-scaling and free disposability.}
\item{\code{3} / \code{"crs"}}{Constant returns to scale, convexity and free disposability.}
\item{\code{4} / \code{"irs"}}{Increasing returns to scale (up-scaling, not down-scaling), convexity and free disposability.}
\item{\code{5} / \code{"add"}}{Additivity (scaling up and down, but only with integers), and free disposability.}
}}

\item{balance_data}{A numeric vector indicating the different levels of balance required (e.g., c(0.1, 0.45, 0.6)).}

\item{seed}{Integer. Seed for reproducibility.}
}
\value{
A \code{list} where each element corresponds to a balance level, containing a single \code{data.frame}
with the real and synthetic DMUs, correctly labeled.
}
\description{
This function creates new DMUs to address data imbalances.
If the majority class is efficient, it generates new inefficient DMUs by worsering the observed units.
Conversely, if the majority class is inefficient, it projects inefficient DMUs to the frontier.
Finally, a random selection if performed to keep a proportion of 0.65 for the majority class and 0.35 for the minority class.
}
