% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-original-bipartite-interactive.R
\name{plotBipartiteInteractive}
\alias{plotBipartiteInteractive}
\title{Use the incidence matrix to plot an interactive bipartite network}
\usage{
plotBipartiteInteractive(inc_mat)
}
\arguments{
\item{inc_mat}{A matrix, the incidence matrix of bipartite network.}
}
\value{
An visNetwork object for interactive figure.
}
\description{
This function converts the input incidence matrix into a bipartite network, and generates a customized interactive bipartite network visualization.
}
\details{
This function creates customized interactive visualization for bipartite networks. The user can enter a simple incidence matrix to generate a dynamic network with a bipartite network layout, in which two parts use different colors and shapes to represent nodes. This function relies on the visNetwork package.
}
\examples{
# load part of the beatAML data
beatAML_data <- NIMAA::beatAML[1:10000,]

# convert to incidence matrix
beatAML_incidence_matrix <- nominalAsBinet(beatAML_data)

# plot with the interactive bipartite network

plotBipartiteInteractive(inc_mat = beatAML_incidence_matrix)
}
\seealso{
\code{\link[visNetwork]{visNetwork}}
}
