% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl-def-CooCoe.R
\name{Coo}
\alias{Coo}
\title{Coo "super" class}
\usage{
Coo(...)
}
\arguments{
\item{...}{anything and, anyway, this function will simply returns a message.}
}
\value{
a list of class Coo
}
\description{
\code{Coo} class is the 'parent' or 'super' class of
\code{\link{Out}}, \code{\link{Opn}} and \code{\link{Ldk}} classes.
}
\details{
Useful shortcuts are described below. See \code{browseVignettes("Momocs")} for
a detail of the design behind Momocs' classes.

\code{Coo} class is the 'parent' class of the following 'child' classes \itemize{
\item \code{\link{Out}} for closed \bold{out}lines
\item \code{\link{Opn}} for \bold{op}e\bold{n} outlines
\item \code{\link{Ldk}} for configuration of \bold{l}an\bold{d}mar\bold{k}s
}

Since all 'child classes' of them handle \eqn{(x; y)} coordinates among other generic methods,
but also all have their specificity, this architecture allow to recycle generic methods and
to use specific methods.

In other words, \code{\link{Out}}, \code{\link{Opn}} and \code{\link{Ldk}} classes
are all, primarily, \code{Coo} objects on which we define generic \emph{and}
specific methods. See their respective help pages for more help.

\code{Coo} objects all have the following components:
\itemize{
\item \verb{$coo} which is a list of matrices for coordinates
\item \verb{$fac} a \code{data_frame} for covariates (if any). You can provide
this data_frame directly, as long as it has as many rows as there are matrices in \verb{$coo} (see examples),
or use an helper function such as \link{lf_structure}.
}

You can access all the methods available for \code{Coo} objects
with \code{methods(class=Coo)}.
}
\examples{
# to see all methods for Coo objects.
methods(class='Coo')

# to see all methods for Out objects.
methods(class='Out') # same for Opn and Ldk

# Let's take an Out example. But all methods shown here
# work on Ldk (try on 'wings') and on Opn ('olea')
bot

# Primarily a 'Coo' object, but also an 'Out'
class(bot)
inherits(bot, "Coo")
panel(bot)
stack(bot)

# Getters (you can also use it to set data)
bot[1] \%>\% coo_plot()
bot[1:5] \%>\% str()

# Setters
bot[1] <- shapes[4]
panel(bot)

bot[1:5] <- shapes[4:8]
panel(bot)

# access the different components
# $coo coordinates
head(bot$coo)
# $fac grouping factors
head(bot$fac)
# or if you know the name of the column of interest
bot$type
# table
table(bot$fac)
# an internal view of an Out object
str(bot)

# subsetting
# see ?filter, ?select, and their 'see also' section for the
# complete list of dplyr-like verbs implemented in Momocs

length(bot) # the number of shapes
names(bot) # access all individual names
bot2 <- bot
names(bot2) <- paste0('newnames', 1:length(bot2)) # define new names

# Add a $fac from scratch
coo <- bot[1:5] # a list of five matrices
length(coo)
sapply(coo, class)

fac <- data.frame(name=letters[1:5], value=c(5:1))
# Then you have to define the subclass using the right builder
# here we have outlines, so we use Out
x <- Out(coo, fac)
x$coo
x$fac
}
\seealso{
Other classes: 
\code{\link{Coe}()},
\code{\link{Ldk}()},
\code{\link{OpnCoe}()},
\code{\link{Opn}()},
\code{\link{OutCoe}()},
\code{\link{Out}()},
\code{\link{TraCoe}()}
}
\concept{classes}
