% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mexico_life_expectancy.R
\name{get_mexico_life_expectancy}
\alias{get_mexico_life_expectancy}
\title{Get Mexico's Life Expectancy from World Bank}
\usage{
get_mexico_life_expectancy()
}
\value{
A tibble with the following columns:
\describe{
  \item{indicator}{Indicator name (e.g., "Life expectancy at birth, total (years)")}
  \item{country}{Country name ("Mexico")}
  \item{year}{Year of the data (integer)}
  \item{value}{Life expectancy in years (numeric)}
}
}
\description{
Retrieves Mexico's life expectancy at birth (in years)
for the years 2010 to 2022 using the World Bank Open Data API.
The indicator used is `SP.DYN.LE00.IN`.
}
\details{
The function sends a GET request to the World Bank API.
If the API request fails or returns an error status code, the function returns `NULL` with a message.
}
\note{
Requires internet connection. Data is retrieved in real time from the World Bank API.
}
\examples{
if (interactive()) {
  get_mexico_life_expectancy()
}

}
\seealso{
\link[httr]{GET}, \link[jsonlite]{fromJSON}, \link[dplyr]{as_tibble}
}
