% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_edge_assignments.R
\name{load_edge_assignments}
\alias{load_edge_assignments}
\title{Efficiently loads a BWA (or other EDGE-like taxonomic assignment) tables from a list
of files. Outputs a named list of assignments.}
\usage{
load_edge_assignments(filepath, type)
}
\arguments{
\item{filepath}{the path to tab delimited, two-column file whose first column is a project_id
(which will be used to name this assignment) and the second column is the assignment filename.}

\item{type}{the type of assignments to be loaded. Following types are recognized: 'bwa',
'diamond', 'gottcha', 'gottcha2', 'kraken', 'metaphlan', and 'pangia'.}
}
\value{
a list of all read assignments.
}
\description{
Efficiently loads a BWA (or other EDGE-like taxonomic assignment) tables from a list
of files. Outputs a named list of assignments.
}
\examples{
hmp_even_fp <- system.file("extdata", "HMP_even", package="MetaComp")
hmp_stagger_fp <- system.file("extdata", "HMP_stagger", package="MetaComp")
data_files <- data.frame(V1 = c("HMP_even", "HMP_stagger"),
                         V2 = c(file.path(hmp_even_fp, "allReads-gottcha2-speDB-b.list.txt"),
                                file.path(hmp_stagger_fp, "allReads-gottcha2-speDB-b.list.txt")))
write.table(data_files, file.path(tempdir(), "assignments.txt"),
                                                 row.names = FALSE, col.names = FALSE)
gottcha2_assignments = load_edge_assignments(file.path(tempdir(), "assignments.txt"),
                                                                            type = "gottcha2")

names(gottcha2_assignments)
table(gottcha2_assignments[[1]]$LEVEL)

}
