% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MBplotBlocks.R
\name{MBplotBlocks}
\alias{MBplotBlocks}
\title{Customizable plots of blocks related information}
\usage{
MBplotBlocks(
  res,
  which = "explained.blocks&Y",
  axes = c(1, 2),
  blocks.axes = 1:max(axes),
  title = NULL,
  size = 2.25
)
}
\arguments{
\item{res}{An object resulting from \code{\link{MBPCA}}, \code{\link{ComDim}}, \code{\link{MBPLS}} or \code{\link{MBWCov}}.}

\item{which}{Either "explained.blocks&Y", "scree", "structure" or "blocks.axes". See details.}

\item{axes}{Which global dimensions should be plotted? Only useful if \emph{which=structure} or \emph{which=blocks.axes}}

\item{blocks.axes}{Which individual blocks dimensions should be correlated with global ones? Only useful if \emph{which=blocks.axes}}

\item{title}{An optional title to be added to the plot.}

\item{size}{The overall size of labels, points, etc.}
}
\value{
The required plot.
}
\description{
Plots blocks related information of \code{\link{MBPCA}}, \code{\link{ComDim}}, \code{\link{MBPLS}} or \code{\link{MBWCov}} with several options of customization.
}
\details{
\itemize{
\item \strong{explained.blocks&Y}: Barplot of the percentages of inertia explained in each block of variables (and Y for \code{\link{MBPLS}} or \code{\link{MBWCov}}) by each global components.
\item \strong{scree}: Barplot of the saliences of each block of variables on each global components.
\item \strong{structure}: Blocks coordinates (saliences) on the global selected \emph{axes}
\item \strong{blocks.axes}: Correlations of the selected individual \emph{blocks.axes} with the global selected \emph{axes}.
}
}
\examples{
# Unsupervised example

data(ham)
X=ham$X
block=ham$block
res.mbpca <- MBPCA(X,block, name.block=names(block))
MBplotBlocks(res.mbpca,which="explained.blocks&Y")
MBplotBlocks(res.mbpca,which="scree")
MBplotBlocks(res.mbpca,which="structure")
MBplotBlocks(res.mbpca,which="blocks.axes")

# Supervised example

data(ham)
X=ham$X
block=ham$block
Y=ham$Y
res.mbpls <- MBPLS(X, Y, block, name.block=names(block))
MBplotBlocks(res.mbpls,which="explained.blocks&Y")
MBplotBlocks(res.mbpls,which="scree")
MBplotBlocks(res.mbpls,which="structure")
MBplotBlocks(res.mbpls,which="blocks.axes")

}
\seealso{
\code{\link{plot.MBPCA}} \code{\link{plot.ComDim}} \code{\link{plot.MBPLS}} \code{\link{plot.MBWCov}}
}
