% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/Script_DROPLET_09_ADHOC_GENE_2_TabulateExpression_PSI.R
\name{adhocGene.TabulateExpression.PSI.10x}
\alias{adhocGene.TabulateExpression.PSI.10x}
\title{Dotplot of splice junction expression values for a specified gene}
\usage{
adhocGene.TabulateExpression.PSI.10x(MarvelObject, min.pct.cells = 10)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{adhocGene.TabulateExpression.Gene.10x} function.}

\item{min.pct.cells}{Numeric value. Percentage of cell expressing the splice junction in a cell group, below which, the value be re-coded as missing and appear will be omitted from the plot. A splice junction is considered to be expressed in a given cell if it has count >=1.}
}
\value{
An object of class S3 with new slots \code{MarvelObject$adhocGene$Expression$PSI$Table} and  \code{MarvelObject$adhocGene$Expression$PSI$Plot}.
}
\description{
Creates a dotplot of splice junction expression value of a specified gene across different cell groups. The gene and cell groups were defined earlier in \code{adhocGene.TabulateExpression.Gene.10x} function.
}
\examples{

marvel.demo.10x <- readRDS(system.file("extdata/data",
                               "marvel.demo.10x.rds",
                               package="MARVEL")
                               )

# SJ usage profiling
marvel.demo.10x <- adhocGene.TabulateExpression.PSI.10x(
                        MarvelObject=marvel.demo.10x,
                        min.pct.cells=10
                        )

# Check output
marvel.demo.10x$adhocGene$Expression$PSI$Plot
}
