% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_DROPLET_09_ADHOC_GENE_5_PlotDEValues.R
\name{adhocGene.PlotDEValues.10x}
\alias{adhocGene.PlotDEValues.10x}
\title{Plot differential splice junction analysis results for a specified gene}
\usage{
adhocGene.PlotDEValues.10x(
  MarvelObject,
  coord.intron,
  log2fc.gene = 0.5,
  delta.sj = 5,
  label.size = 2,
  point.size = 2,
  xmin = NULL,
  xmax = NULL,
  ymin = NULL,
  ymax = NULL
)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{adhocGene.DE.Gene.10x} and \code{adhocGene.DE.PSI.10x} functions.}

\item{coord.intron}{Character string. Coordinates of splice junction whose differential splice junction results will be plotted.}

\item{log2fc.gene}{Numeric value. Absolute log2 fold change, above which, the gene is considered differentially expressed.}

\item{delta.sj}{Numeric value. Absolute differences in average PSI values between the two cell groups, above which, the splice junction is considered differentially spliced.}

\item{label.size}{Numeric value. The font size of the group comparison labels on the plot will be adjusted to the size specified here. Default is \code{2}.}

\item{point.size}{Numeric value. Size of data points. Default is \code{2}.}

\item{xmin}{Numeric value. Minimum x-axis value.}

\item{xmax}{Numeric value. Maximum x-axis value.}

\item{ymin}{Numeric value. Minimum y-axis value.}

\item{ymax}{Numeric value. Maximum y-axis value.}
}
\value{
An object of class S3 with a new slots \code{MarvelObject$adhocGene$DE$VolcanoPlot$Plot} and \code{MarvelObject$adhocGene$DE$VolcanoPlot$Table}.
}
\description{
Scatterplot of results from differential gene and splice junction analysis. x-axis represents the gene expression log2 fold change between the different pairs of cell groups. y-axis represents the PSI differences or log2 fold change between the different pairs of cell groups.
}
\examples{

marvel.demo.10x <- readRDS(system.file("extdata/data",
                               "marvel.demo.10x.rds",
                               package="MARVEL")
                               )

# Define SJ to plot
coord.intron <- marvel.demo.10x$adhocGene$DE$PSI$Data$coord.intron[1]

# Plot SJ vs gene
marvel.demo.10x <- adhocGene.PlotDEValues.10x(
                        MarvelObject=marvel.demo.10x,
                        coord.intron=coord.intron,
                        log2fc.gene=0.5,
                        delta.sj=5,
                        label.size=2,
                        point.size=2,
                        xmin=-2.0,
                        xmax=2.0,
                        ymin=-25,
                        ymax=25
                        )

# Check output
marvel.demo.10x$adhocGene$DE$VolcanoPlot$Plot
}
