% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_03_COMPUTE_PSI_5_Compute_RI.R
\name{ComputePSI.RI}
\alias{ComputePSI.RI}
\title{Compute retained-intron (RI) percent spliced-in (PSI) values}
\usage{
ComputePSI.RI(
  MarvelObject,
  CoverageThreshold,
  IntronCounts,
  thread,
  read.length = 1
)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CreateMarvelObject} function.}

\item{CoverageThreshold}{Numeric value. Coverage threshold below which the PSI of the splicing event will be censored, i.e. annotated as missing (NA). Coverage defined as the total number of reads supporting both included and excluded isoforms.}

\item{IntronCounts}{Data frame. Columns indicate sample IDs, rows indicate intron coordinates, and values indicate total intron coverage. The first column needs to be named \code{coord.intron}. These values will be combined with splice junction counts in the MARVEL object to compute PSI values.}

\item{thread}{Numeric value. Set number of threads.}

\item{read.length}{Numeric value. The length of read. This number will be specific to the sequencing mode. E.g. read length should be set to \code{150} when samples were sequenced in 150bp paired-end or single-end. This option should only be specified when users used read-counting approach for computing intron counts. The option should be left with its default value \code{1} when users tabulated the per-base count and summed them up to arrive at the intron counts.}
}
\value{
An object of class S3 with new slots \code{$SpliceFeatureValidated$RI} and \code{$PSI$RI}.
}
\description{
Validate RI splicing events and subsequently computes percent spliced-in (PSI) values these high-quality splicing events.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

marvel.demo <- ComputePSI.RI(MarvelObject=marvel.demo,
                             CoverageThreshold=10,
                             IntronCounts=marvel.demo$IntronCounts,
                             thread=1
                             )
}
