/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.WrapperDoubleMatrix2D;

public class SparseRCMDoubleMatrix2D
extends WrapperDoubleMatrix2D {
    private static final long serialVersionUID = 1L;
    private SparseDoubleMatrix1D[] elements;

    public SparseRCMDoubleMatrix2D(int n, int n2) {
        block3: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                throw illegalArgumentException;
            }
        }
        this.elements = new SparseDoubleMatrix1D[n];
        for (int i = 0; i < n; ++i) {
            this.elements[i] = new SparseDoubleMatrix1D(n2);
        }
    }

    public SparseDoubleMatrix1D[] elements() {
        return this.elements;
    }

    public double getQuick(int n, int n2) {
        return this.elements[n].getQuick(n2);
    }

    public void setQuick(int n, int n2, double d) {
        this.elements[n].setQuick(n2, d);
    }

    public void trimToSize() {
        for (int i = 0; i < this.rows; ++i) {
            this.elements[i].trimToSize();
        }
    }

    public SparseDoubleMatrix1D viewRow(int n) {
        return this.elements[n];
    }

    protected DoubleMatrix2D getContent() {
        return this;
    }

    public DoubleMatrix2D like(int n, int n2) {
        return new SparseRCMDoubleMatrix2D(n, n2);
    }
}

