% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HVTMSMoptimization.R
\name{HVTMSMoptimization}
\alias{HVTMSMoptimization}
\title{HVT-MSM Optimization Function}
\usage{
HVTMSMoptimization(
  entire_dataset,
  expost_forecasting,
  time_column,
  ncell_range = 3:5,
  k_range = 2:9,
  nn_range = 2:7,
  num_simulations = 10,
  mae_metric,
  hvt_params = list(depth = 1, quant.err = 0.2, normalize = TRUE, distance_metric =
    "L1_Norm", error_metric = "max", dim_reduction_method = "sammon"),
  parallel = TRUE,
  verbose = TRUE,
  parallel_strategy = "multisession",
  max_workers = NULL
)
}
\arguments{
\item{entire_dataset}{Dataframe. Train dataset for model training}

\item{expost_forecasting}{Dataframe. Test dataset for ex-post forecasting}

\item{time_column}{Character. Name of the time column}

\item{ncell_range}{Numeric vector. Range of cells to run experiments (default 3:5)}

\item{k_range}{Numeric vector. Range of clusters to run experiments (default: 2:9)}

\item{nn_range}{Numeric vector. Range of nearest neighbors to run experiments (default: 2:7)}

\item{num_simulations}{Integer. Number of simulations (default: 10)}

\item{mae_metric}{Character. MAE calculation method(s): "mean", "median", "mode", or
"all" (default: "median")}

\item{hvt_params}{List. Set of parameters for Model Training (refer trainHVT)}

\item{parallel}{Character. Whether to use parallel processing (default: TRUE)}

\item{verbose}{Character. Whether to print progress information (default: TRUE)}

\item{parallel_strategy}{Character. Parallel processing strategy: "multisession", 
"multicore", etc. (default: "multisession")}

\item{max_workers}{Maximum number of parallel workers 
(default: NULL for auto-detect)}
}
\value{
List containing optimization results for each MAE metric:
\item{[[successful_results]] }{All successful parameter combinations} 
\item{[[nclust_best_results]] }{Best combination for each cell}
\item{[[overall_best]] }{Overall best parameter combination}
\item{[[all_results]] }{All attempted combinations with status}
}
\description{
This function runs multiple iterations/experiments over the dataset across 
different cell counts, and computes the MAE. If a given cell configuration 
not results in problematic states, the baseline simulation is used; otherwise, 
the simulation proceeds with problematic state handling. This process helps identify 
the best-performing model (lowest MAE). In essence, it performs 
trainHVT → scoreHVT → transition probability estimation on the training 
data, followed by msm simulation on the ex-post (test) dataset.  
Note: This is not applicable for ex-ante analysis.
}
\author{
Vishwavani <vishwavani@mu-sigma.com>, Nithya <nithya.sn@mu-sigma.com>
}
\keyword{Hyperparameter_Tuning}
