% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HierarchyContributors.R
\name{HierarchyContributors}
\alias{HierarchyContributors}
\title{Counts of input code contributions}
\usage{
HierarchyContributors(data, x, crossTable, hierarchies, inputInOutput = TRUE)
}
\arguments{
\item{data}{input data}

\item{x}{model matrix as created by \code{ModelMatrix} with \code{data}, \code{hierarchies} and \code{inputInOutput} as input}

\item{crossTable}{\code{crossTable} as created by \code{ModelMatrix} with \code{data}, \code{hierarchies} and \code{inputInOutput} as input}

\item{hierarchies}{Standardized hierarchies.  That is, output from \code{AutoHierarchies}.}

\item{inputInOutput}{\code{ModelMatrix} input.}
}
\value{
List of data frames of counts associated with \code{crossTable}
\itemize{
\item \strong{\code{min}:} Minimum number of times a contributing input code contributes
\item \strong{\code{max}:} Maximum number of times a contributing input code contributes
\item \strong{\code{n}:}   Number of contributing input codes
\item \strong{\code{ac}:}  Theoretical number of contributing input codes according to the hierarchy
}
}
\description{
Counts of input code contributions
}
\examples{
z <- SSBtoolsData("sprt_emp_withEU")[-(1:3), ]
z$age[z$age == "Y15-29"] <- "young"
z$age[z$age == "Y30-64"] <- "old"
hi <- SSBtools::FindHierarchies(z[, -4])
inputInOutput <- c(TRUE, FALSE, FALSE)
mm <- SSBtools::ModelMatrix(z, hi, crossTable = TRUE, inputInOutput = inputInOutput)

out <- HierarchyContributors(z, mm$modelMatrix, mm$crossTable, hi, inputInOutput)

# The nonzero values are caused by the removed three data rows
cbind(mm$crossTable, out$max - out$min)
cbind(mm$crossTable, out$ac - out$n)

}
\keyword{internal}
