% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_insert.R
\name{node_insert}
\alias{node_insert}
\title{Insert Nodes into a Tree}
\usage{
node_insert(tree, node.name, ...)
}
\arguments{
\item{tree}{a tree (i.e. a Node object).}

\item{node.name}{a character string specifying the name of a node. Some nodes will be inserted before it.}

\item{...}{some Node objects or character strings.
A character string will be treated as the name of a new node to be created. Those nodes will be inserted into the tree.}
}
\value{
Invisibly returns the parent node of those new nodes.
}
\description{
Scan the tree and insert nodes before the first non-root node having the name specified. \cr
This function is based on the package data.tree and has side-effects.
It modifies the tree given by the argument (see the package data.tree).
}
\examples{
\donttest{
dst.firm <- node_new(
  "output",
  "prod1",  "prod2"
)
plot(dst.firm)

dst.VA <- node_new(
  "VA",
  "lab",  "cap"
)

node_insert(
  dst.firm, "prod1",
  dst.VA, "prod3"
)
node_set(
  dst.firm, "output",
  "prod4"
)
plot(dst.firm)
}
}
