#' @export
#' @title A Time Circle Model with One Consumer and Two Types of Firms
#' @aliases gemIntertemporal_TimeCircle_3_3
#' @description An (intertemporal) time circle model with one consumer and two types of firms.
#' @param ... arguments to be passed to the function sdm2.
#' @examples
#' \donttest{
#' #### an example with a Cobb-Douglas intertemporal utility function
#' np <- 5 # the number of economic periods, firms.
#' zeta <- 1.25 # the ratio of repayments to loans
#'
#' n <- 3 * np # the number of commodity kinds
#' m <- 2 * np + 1 # the number of agent kinds
#'
#' names.commodity <- c(
#'   paste0("corn", 1:np),
#'   paste0("iron", 1:np),
#'   paste0("lab", 1:np)
#' )
#' names.agent <- c(
#'   paste0("firm.corn", 1:np),
#'   paste0("firm.iron", 1:np),
#'   "consumer"
#' )
#'
#' # the exogenous supply matrix.
#' S0Exg <- matrix(NA, n, m, dimnames = list(names.commodity, names.agent))
#' S0Exg[paste0("lab", 1:np), "consumer"] <- 100 # the supply of labor
#'
#' # the output coefficient matrix.
#' B <- matrix(0, n, m, dimnames = list(names.commodity, names.agent))
#' for (k in 1:(np - 1)) {
#'   B[paste0("corn", k + 1), paste0("firm.corn", k)] <- 1
#'   B[paste0("iron", k + 1), paste0("firm.iron", k)] <- 1
#' }
#' B["corn1", paste0("firm.corn", np)] <- 1 / zeta
#' B["iron1", paste0("firm.iron", np)] <- 1 / zeta
#'
#' dstl.firm.corn <- dstl.firm.iron <- list()
#' for (k in 1:np) {
#'   dstl.firm.corn[[k]] <- node_new(
#'     "prod",
#'     type = "CD",
#'     alpha = 1, beta = c(0.5, 0.5),
#'     paste0("iron", k), paste0("lab", k)
#'   )
#'
#'   dstl.firm.iron[[k]] <- node_new(
#'     "prod",
#'     type = "CD",
#'     alpha = 2, beta = c(0.5, 0.5),
#'     paste0("iron", k), paste0("lab", k)
#'   )
#' }
#'
#' dst.consumer <- node_new(
#'   "util",
#'   type = "CD", alpha = 1,
#'   beta = prop.table(rep(1, np)),
#'   paste0("corn", 1:np)
#' )
#'
#' ge <- sdm2(
#'   A = c(dstl.firm.corn, dstl.firm.iron, dst.consumer),
#'   B = B,
#'   S0Exg = S0Exg,
#'   names.commodity = names.commodity,
#'   names.agent = names.agent,
#'   numeraire = "lab1",
#'   ts = TRUE
#' )
#'
#' ge$p
#' ge$z
#' ge$D
#' ge$S
#' ge$DV
#' ge$SV
#' }

gemIntertemporal_TimeCircle_3_3 <- function(...) sdm2(...)
