% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_attributes.R
\name{get_attributes}
\alias{get_attributes}
\title{get_attributes}
\usage{
get_attributes(x, eml = NULL)
}
\arguments{
\item{x}{an "attributeList" element from an emld object}

\item{eml}{The full eml document, needed only if <references> outside of attributes must be resolved.}
}
\value{
a data frame whose rows are the attributes (names of each column in the data file)
and whose columns describe metadata about those attributes.  By default separate tables
are given for each type
}
\description{
get_attributes
}
\details{
EML metadata can use "references" elements which allow one attribute to use metadata
declared elsewhere in the document.  This function will automatically resolve these references
and thus infer the correct metadata.
}
\examples{
f <- system.file("tests", emld::eml_version(), 
  "eml-datasetWithAttributelevelMethods.xml", package = "emld")
eml <- read_eml(f)
get_attributes(eml$dataset$dataTable$attributeList)
}
