% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_stations.R
\name{get_stations}
\alias{get_stations}
\title{Get Station Data}
\usage{
get_stations()
}
\value{
a tibble
}
\description{
This function downloads detailed information for each SamplingPointId. It performs a spatial join to merge the spatial information of LAU and NUTS (specifically, the geometries of LAU and the geometry of stations) and fills in the missing data for CITY_NAME and CITY_ID (retrieved from https://discomap.eea.europa.eu/App/AQViewer/index.html?fqn=Airquality_Dissem.b2g.AirQualityStatistics) through a left join based on the AirQualityStationEoICode column. These values are essential for querying the endpoint.
The missing_cities file was obtained manually (from 2000 to 2024) because the website did not allow downloading more than 100,000 rows at a time. The data was collected in multiple batches, filtering SamplingPoints using the following criteria:
\itemize{
\item Filter on data used in AQ Report: yes
\item Filter on data coverage: yes
For each station, the column AirQualityStationEoICode (identical for all sensors at the same station) was used to select the first row containing unique values for CITY_NAME and CITY_ID. No station reported more than one value for this pair of columns.
To support future uploads, it is necessary to integrate updated AirQualityStationEoICode values.
}
}
