% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.R
\docType{data}
\name{scores}
\alias{scores}
\title{DIVINE's table on severity scores at hospital admission}
\format{
A data frame with 5813 rows and 10 columns
\describe{
\item{record_id:}{Identifier of each record. This information does not match the real data.}
\item{covid_wave:}{A factor with levels \verb{Wave 1}, \verb{Wave 2}, \verb{Wave 3}, and \verb{Wave 5}. COVID-19 wave.}
\item{center:}{A factor with levels \verb{Hospital A}, \verb{Hospital B}, \verb{Hospital C}, \verb{Hospital D}, and \verb{Hospital E}. Center of admission}
\item{psi:}{Pneumonia severity index (PSI) at hospital admission}
\item{group_psi:}{A factor with levels \code{1}, \code{2}, \code{3}, and \code{4}. PSI group}
\item{curb65:}{CURB65 score at hospital admission}
\item{group_curb65:}{A factor with levels \code{1}, \code{2}, and \code{3}. CURB65 group}
\item{mulbsta:}{MULBSTA score at hospital admission}
\item{group_mulbsta:}{A factor with levels \code{Low-risk} and \code{High-risk}. MULBSTA group}
\item{rox_index:}{ROX index at hospital admission}
}
}
\usage{
data(scores)
}
\description{
Information on severity scores at hospital admission for patients included in the DIVINE cohort. Data was collected at hospital admission.
}
\references{
Pallarès, N., Tebé, C., Abelenda-Alonso, G., Rombauts, A., Oriol, I., Simonetti, A. F., Rodríguez-Molinero, A., Izquierdo, E., Díaz-Brito, V., Molist, G., Gómez Melis, G., Carratalà, J., Videla, S., & MetroSud and Divine study groups (2023). Characteristics and Outcomes by Ceiling of Care of Subjects Hospitalized with COVID-19 During Four Waves of the Pandemic in a Metropolitan Area: A Multicenter Cohort Study. Infectious diseases and therapy, 12(1), 273–289. https://doi.org/10.1007/s40121-022-00705-w
}
\keyword{datasets}
