% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.TrainOutput.R
\name{TrainOutput}
\alias{TrainOutput}
\title{Stores the results achieved during training.}
\description{
This class manages the results achieved during training stage
(such as optimized hyperparameters, model information, utilized metrics).
}
\seealso{
\code{\link{D2MCS}}
}
\keyword{attribute}
\keyword{datasets}
\keyword{manip}
\keyword{programming}
\keyword{utilities}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TrainOutput-new}{\code{TrainOutput$new()}}
\item \href{#method-TrainOutput-getModels}{\code{TrainOutput$getModels()}}
\item \href{#method-TrainOutput-getPerformance}{\code{TrainOutput$getPerformance()}}
\item \href{#method-TrainOutput-savePerformance}{\code{TrainOutput$savePerformance()}}
\item \href{#method-TrainOutput-plot}{\code{TrainOutput$plot()}}
\item \href{#method-TrainOutput-getMetrics}{\code{TrainOutput$getMetrics()}}
\item \href{#method-TrainOutput-getClassValues}{\code{TrainOutput$getClassValues()}}
\item \href{#method-TrainOutput-getPositiveClass}{\code{TrainOutput$getPositiveClass()}}
\item \href{#method-TrainOutput-getSize}{\code{TrainOutput$getSize()}}
\item \href{#method-TrainOutput-clone}{\code{TrainOutput$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainOutput-new"></a>}}
\if{latex}{\out{\hypertarget{method-TrainOutput-new}{}}}
\subsection{Method \code{new()}}{
Function used to initialize the object arguments during
runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainOutput$new(models, class.values, positive.class)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{models}}{A \link{list} containing the best M.L. model for each
cluster.}

\item{\code{class.values}}{A \link{character} vector containing the values of
the target class.}

\item{\code{positive.class}}{A \link{character} with the value of the positive
class.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainOutput-getModels"></a>}}
\if{latex}{\out{\hypertarget{method-TrainOutput-getModels}{}}}
\subsection{Method \code{getModels()}}{
The function is used to obtain the best M.L. model of each
cluster.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainOutput$getModels(metric)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metric}}{A \link{character} vector which specifies the metric(s)
used for configuring M.L. hyperparameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{list} is returned of class train.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainOutput-getPerformance"></a>}}
\if{latex}{\out{\hypertarget{method-TrainOutput-getPerformance}{}}}
\subsection{Method \code{getPerformance()}}{
The function returns the performance value of M.L. models
during training stage.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainOutput$getPerformance(metrics = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metrics}}{A \link{character} vector which specifies the metric(s)
used to train the M.L. models.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{character} vector containing the metrics used for
configuring M.L. hyperparameters.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainOutput-savePerformance"></a>}}
\if{latex}{\out{\hypertarget{method-TrainOutput-savePerformance}{}}}
\subsection{Method \code{savePerformance()}}{
The function is used to save into CSV file the performance
achieved by the M.L. models during training stage.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainOutput$savePerformance(dir.path, metrics = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir.path}}{The location to store the into a CSV file the performance
of the trained M.L.}

\item{\code{metrics}}{An optional parameter specifying the metric(s) used to
train the M.L. models. If not defined, all the metrics used in train
stage will be saved.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainOutput-plot"></a>}}
\if{latex}{\out{\hypertarget{method-TrainOutput-plot}{}}}
\subsection{Method \code{plot()}}{
The function is responsible for creating a plot to visualize
the performance achieved by the best M.L. model on each cluster.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainOutput$plot(dir.path, metrics = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir.path}}{The location to store the exported plot will be saved.}

\item{\code{metrics}}{An optional parameter specifying the metric(s) used to
train the M.L. models. If not defined, all the metrics used in train
stage will be plotted.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainOutput-getMetrics"></a>}}
\if{latex}{\out{\hypertarget{method-TrainOutput-getMetrics}{}}}
\subsection{Method \code{getMetrics()}}{
The function returns all metrics used for configuring M.L.
hyperparameters during train stage.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainOutput$getMetrics()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainOutput-getClassValues"></a>}}
\if{latex}{\out{\hypertarget{method-TrainOutput-getClassValues}{}}}
\subsection{Method \code{getClassValues()}}{
The function is used to get the values of the target class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainOutput$getClassValues()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} containing the values of the target class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainOutput-getPositiveClass"></a>}}
\if{latex}{\out{\hypertarget{method-TrainOutput-getPositiveClass}{}}}
\subsection{Method \code{getPositiveClass()}}{
The function returns the value of the positive class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainOutput$getPositiveClass()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} vector of size 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainOutput-getSize"></a>}}
\if{latex}{\out{\hypertarget{method-TrainOutput-getSize}{}}}
\subsection{Method \code{getSize()}}{
The function is used to get the number of the trained M.L.
models. Each cluster contains the best M.L. model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainOutput$getSize()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{numeric} value or \link{NULL} training was not
successfully performed.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TrainOutput-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TrainOutput-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TrainOutput$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
