% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.Prediction.R
\name{Prediction}
\alias{Prediction}
\title{Manages the prediction computed for a specific model.}
\description{
Allows to obtain predictions from the data provided using a pre-trained model.
}
\seealso{
\code{\link{ClusterPredictions}}
}
\keyword{internal}
\keyword{math}
\keyword{misc}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Prediction-new}{\code{Prediction$new()}}
\item \href{#method-Prediction-execute}{\code{Prediction$execute()}}
\item \href{#method-Prediction-getPrediction}{\code{Prediction$getPrediction()}}
\item \href{#method-Prediction-getModelName}{\code{Prediction$getModelName()}}
\item \href{#method-Prediction-getModelPerformance}{\code{Prediction$getModelPerformance()}}
\item \href{#method-Prediction-clone}{\code{Prediction$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Prediction-new"></a>}}
\if{latex}{\out{\hypertarget{method-Prediction-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Prediction$new(model, feature.id = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{A \link{list} containing the information of the
trained model composed of five elements: "model.name", "exec.time",
"model.performance", "model.data" and "model.libs".}

\item{\code{feature.id}}{A \link{character} value containing the column name
used as identifier.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Prediction-execute"></a>}}
\if{latex}{\out{\hypertarget{method-Prediction-execute}{}}}
\subsection{Method \code{execute()}}{
Calculates predictions of the values passed by parameters
using the corresponding model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Prediction$execute(pred.values, class.values, positive.class)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pred.values}}{A \link{data.frame} containing the values to predict.}

\item{\code{class.values}}{A \link{vector} containing the class values.}

\item{\code{positive.class}}{A \link{character} value containing the positive
class.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Prediction-getPrediction"></a>}}
\if{latex}{\out{\hypertarget{method-Prediction-getPrediction}{}}}
\subsection{Method \code{getPrediction()}}{
The function is used to return the prediction values
computed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Prediction$getPrediction(type = NULL, target = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{A \link{character} to define which type of predictions
should be returned. If not defined all type of probabilities will be
returned. Conversely if "prob" or "raw" is defined then computed
'probabilistic' or 'class' values are returned.}

\item{\code{target}}{A \link{character} defining the value of the positive
class.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{data.frame} with the computed prediction.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Prediction-getModelName"></a>}}
\if{latex}{\out{\hypertarget{method-Prediction-getModelName}{}}}
\subsection{Method \code{getModelName()}}{
Gets the model name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Prediction$getModelName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \link{character} value of model value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Prediction-getModelPerformance"></a>}}
\if{latex}{\out{\hypertarget{method-Prediction-getModelPerformance}{}}}
\subsection{Method \code{getModelPerformance()}}{
Gets the performance of the model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Prediction$getModelPerformance()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The \link{numeric} value of the model's performance.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Prediction-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Prediction-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Prediction$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
