% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetCollections.R
\name{GetCollections}
\alias{GetCollections}
\title{List available collections}
\source{
\url{https://documentation.dataspace.copernicus.eu/APIs/SentinelHub/Catalog.html}
}
\usage{
GetCollections(as_data_frame = TRUE, url = getOption("CDSE.catalog_url"))
}
\arguments{
\item{as_data_frame}{logical indicating if the result should be returned as data frame. Default: TRUE}

\item{url}{character indicating the STAC catalog search endpoint. Default: Copernicus Data Space Ecosystem STAC endpoint}
}
\value{
A \code{list} or a \code{data.frame} of all available imagery collections and their attributes.
}
\description{
Retrieves the list of available imagery collections.
}
\details{
This function doesn't require authentication.
}
\examples{
\dontrun{
GetCollections(as_data_frame = TRUE)
}
}
\seealso{
\code{\link[CDSE]{GetImage}}, \code{\link[CDSE]{SearchCatalog}}
}
