% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_class_directory.R
\name{register_graph_class}
\alias{register_graph_class}
\title{Extensible registry of Microsoft Graph classes that AzureGraph supports}
\usage{
register_graph_class(name, R6_generator, check_function)
}
\arguments{
\item{name}{The name of the Graph class, eg "user", "servicePrincipal", etc.}

\item{R6_generator}{An R6 class generator corresponding to this Graph class.}

\item{check_function}{A boolean function that checks if a list of properties is for an object of this class.}
}
\value{
An invisible vector of registered class names.
}
\description{
Extensible registry of Microsoft Graph classes that AzureGraph supports
}
\details{
As written, AzureGraph knows about a subset of all the object classes contained in Microsoft Graph. These are mostly the classes originating from Azure Active Directory: users, groups, app registrations, service principals and registered devices.

You can extend AzureGraph by writing your own R6 class that inherits from \code{ms_object}. If so, you should also \emph{register} your class by calling \code{register_graph_class} and providing the generator object, along with a check function. The latter should accept a list of object properties (as obtained from the Graph REST API), and return TRUE/FALSE based on whether the object is of your class.
}
\examples{
\dontrun{

# built-in 'az_user' class, for an AAD user object
register_graph_class("user", az_user,
   function(props) !is.null(props$userPrincipalName))

}
}
