% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_graph_pager.R
\name{extract_list_values}
\alias{extract_list_values}
\title{Get the list of values from a Graph pager object}
\usage{
extract_list_values(pager, n = Inf)
}
\arguments{
\item{pager}{An object of class \code{ms_graph_pager}, which is an iterator for a list of paged query results.}

\item{n}{The number of items from the list to return. Note this is \emph{not} the number of \emph{pages} (each page will usually contain multiple items). The default value of \code{Inf} extracts all the values from the list, leaving the pager empty. If this is NULL, the pager itself is returned.}
}
\value{
If \code{n} is \code{Inf} or a number, the items from the paged query results. The format of the returned value depends on the pager settings. This will either be a nested list containing the properties for each of the items; a list of R6 objects; or a data frame. If the pager is empty, an error is thrown.

If \code{n} is NULL, the pager itself is returned.
}
\description{
Get the list of values from a Graph pager object
}
\details{
This is a convenience function to perform the common task of extracting all or some of the items from a paged response.
}
\examples{
\dontrun{

firstpage <- call_graph_endpoint(token, "me/memberOf")
pager <- ms_graph_pager$new(token, firstpage)
extract_list_values(pager)

# trying to extract values a 2nd time will fail
try(extract_list_values(pager))

}
}
\seealso{
\link{ms_graph_pager}, \link{ms_object}, \link{call_graph_endpoint}
}
