% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{binChi}
\alias{binChi}
\alias{binMI}
\alias{binAbsDif}
\title{Statistics for bins}
\usage{
binChi(bins, agg = sum)

binMI(bins, agg = sum)

binAbsDif(bins, agg = sum)
}
\arguments{
\item{bins}{a list of bins, each a list with elements `x`, `y`,
`depth`, `bnds` (list with elements `x` and `y`), `expn`, `n`}

\item{agg}{function which is aggregates the individual statistics
computed over each bin}
}
\value{
A list with elements `residuals`, `stat`, and `nbins`
reporting the individual statistic values (possibly transformed),
the aggegrated statistic value, and the number of bins in `bins`
}
\description{
These functions compute statistics based on observed
and expected counts for a list of bins.
}
\details{
Binstatistics

Three functions are provided by default, `binChi`
computes the chi-squared statistic by taking the squared
difference between observed and expected counts and dividing this
by the expected counts. `binMi` computes the mutual information
for each bin using the observed and expected counts. Finally,
`binAbsDif` computes the absolute difference between observed
and expected counts. Each function first computes a value on
every bin independently and stores all these values in memory
before using the function provided in the optional argument `agg`
to aggregate these values.
}
\section{Functions}{
\itemize{
\item \code{binChi()}: Chi-squared statistic

\item \code{binMI()}: Mutual information

\item \code{binAbsDif()}: Absolute difference between observed
and expected

}}
\examples{
binList1 <- list(list(x = c(1,2), y = c(3,1), depth = 1, n = 2,
                      expn = 2),
                list(x = c(3,4), y = c(2,4), depth = 1, n = 2,
                     expn = 2))
binList2 <- list(list(x = c(1,2), y = c(3,1), depth = 6, n = 2,
                      expn = 4),
                list(x = c(), y = c(), depth = 1, n = 0, expn = 1))
binChi(binList1)
binChi(binList2)
binMI(binList1)
binMI(binList2)
binAbsDif(binList2)
}
\author{
Chris Salahub
}
