% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pt_multi.R
\name{pt_multi}
\alias{pt_multi}
\title{Pluto-Tasche method for multi-year probability of default (PD) analysis}
\usage{
pt_multi(pf, num_def, conf_level, num_years)
}
\arguments{
\item{pf}{unconditional portfolio distribution from the worst to the best credit quality}

\item{num_def}{number of defaults in a given rating class}

\item{conf_level}{confidence interval of PD estimates}

\item{num_years}{number of periods used in the PD estimation}
}
\description{
Calculates the variation inflation factors of all predictors in regression models
}
\examples{
pf <- c(10,20,30,40)
num_def <- c(1,2,3,4)
conf_level = 0.99
num_years = 3
pt_multi(pf, num_def, conf_level, num_years)
}
