% Generated by roxygen2: do not edit by hand
\name{dhyper}
\alias{dhyper}
\alias{phyper}
\alias{qhyper}
\alias{rhyper}
\title{The Hypergeometric Distribution}
\arguments{
  \item{m}{number of white balls (successes)}
  \item{n}{number of black balls (failures)}
  \item{k}{number of balls to draw
}
}

\details{
Compute the probability mass at a point (x = 1)
\code{dhyper(0, m = 1, n = 3, k = 1)}
\code{dhyper(1, m = 1, n = 3, k = 1)}

Compute the cumulative probability up to a point (x <= 1)
\code{phyper(1, m = 1, n = 3, k = 1)}

Compute the 95th percentile
\code{qhyper(.95, m = 10, n = 30, k = 10)}

Generate draws (n = 10)
\code{rhyper(10, m = 10, n = 30, k = 10)}}

