/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.integer.branching;

import choco.cp.solver.search.integer.varselector.DomOverWDeg;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.branch.AbstractLargeIntBranchingStrategy;
import choco.kernel.solver.branch.VarSelector;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.search.IntBranchingDecision;
import choco.kernel.solver.search.ValIterator;
import choco.kernel.solver.search.ValSelector;

public class AssignVar
extends AbstractLargeIntBranchingStrategy {
    private final VarSelector varHeuristic;
    private final ValueChooserWrapper wrapper;

    public AssignVar(VarSelector varSel, ValIterator valIterator) {
        this.varHeuristic = varSel;
        this.wrapper = new ValIteratorWrapper(valIterator);
    }

    public AssignVar(VarSelector varSel, ValSelector valSelector) {
        this.varHeuristic = varSel;
        this.wrapper = new ValSelectorWrapper(valSelector);
    }

    @Override
    public Object selectBranchingObject() throws ContradictionException {
        return this.varHeuristic.selectVar();
    }

    @Override
    public boolean finishedBranching(IntBranchingDecision decision) {
        return this.wrapper.finishedBranching(decision);
    }

    @Override
    public void setFirstBranch(IntBranchingDecision decision) {
        decision.setBranchingValue(this.wrapper.getFirstBranch(decision));
    }

    @Override
    public void setNextBranch(IntBranchingDecision decision) {
        decision.setBranchingValue(this.wrapper.getNextBranch(decision));
    }

    @Override
    public void goDownBranch(IntBranchingDecision decision) throws ContradictionException {
        decision.setIntVal();
    }

    @Override
    public void goUpBranch(IntBranchingDecision decision) throws ContradictionException {
        decision.remIntVal();
    }

    @Override
    public String getDecisionLogMessage(IntBranchingDecision decision) {
        return AssignVar.getDefaultAssignMsg(decision);
    }

    @Override
    public void initConstraintForBranching(SConstraint c) {
        if (this.varHeuristic instanceof DomOverWDeg) {
            ((DomOverWDeg)this.varHeuristic).initConstraintForBranching(c);
        }
    }

    protected static final class ValSelectorWrapper
    implements ValueChooserWrapper {
        private final ValSelector valSelector;

        public ValSelectorWrapper(ValSelector valSelector) {
            this.valSelector = valSelector;
        }

        @Override
        public boolean finishedBranching(IntBranchingDecision decision) {
            return decision.getBranchingIntVar().getDomainSize() == 0;
        }

        @Override
        public int getFirstBranch(IntBranchingDecision decision) {
            return this.valSelector.getBestVal(decision.getBranchingIntVar());
        }

        @Override
        public int getNextBranch(IntBranchingDecision decision) {
            return this.valSelector.getBestVal(decision.getBranchingIntVar());
        }
    }

    protected static final class ValIteratorWrapper
    implements ValueChooserWrapper {
        private final ValIterator valHeuristic;

        public ValIteratorWrapper(ValIterator valHeuristic) {
            this.valHeuristic = valHeuristic;
        }

        @Override
        public boolean finishedBranching(IntBranchingDecision decision) {
            return !this.valHeuristic.hasNextVal(decision.getBranchingIntVar(), decision.getBranchingValue());
        }

        @Override
        public int getFirstBranch(IntBranchingDecision decision) {
            return this.valHeuristic.getFirstVal(decision.getBranchingIntVar());
        }

        @Override
        public int getNextBranch(IntBranchingDecision decision) {
            return this.valHeuristic.getNextVal(decision.getBranchingIntVar(), decision.getBranchingValue());
        }
    }

    protected static interface ValueChooserWrapper {
        public boolean finishedBranching(IntBranchingDecision var1);

        public int getFirstBranch(IntBranchingDecision var1);

        public int getNextBranch(IntBranchingDecision var1);
    }
}

