/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.exprtree;

import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.ISpecies;
import net.sourceforge.jclec.base.AbstractRecombinator;
import net.sourceforge.jclec.exprtree.ExprTree;
import net.sourceforge.jclec.exprtree.ExprTreeIndividual;
import net.sourceforge.jclec.exprtree.ExprTreeSchema;
import net.sourceforge.jclec.exprtree.ExprTreeSpecies;
import net.sourceforge.jclec.exprtree.IRecombineExprTree;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;

public class ExprTreeRecombinator
extends AbstractRecombinator
implements IConfigure {
    private static final long serialVersionUID = -964619066855184640L;
    protected IRecombineExprTree baseOp;
    protected transient ExprTreeSpecies species;
    protected transient ExprTreeSchema schema;

    public IRecombineExprTree getBaseOp() {
        return this.baseOp;
    }

    public void setBaseOp(IRecombineExprTree baseOp) {
        this.baseOp = baseOp;
    }

    @Override
    public void configure(Configuration settings) {
        try {
            String baseOpClassname = settings.getString("base-op[@type]");
            Class<?> baseOpClass = Class.forName(baseOpClassname);
            IRecombineExprTree baseOp = (IRecombineExprTree)baseOpClass.newInstance();
            if (baseOp instanceof IConfigure) {
                ((IConfigure)((Object)baseOp)).configure(settings.subset("base-op"));
            }
            this.setBaseOp(baseOp);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal operator classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of operator", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of operator", e);
        }
    }

    @Override
    protected void setPpl() {
        this.ppl = 2;
    }

    @Override
    protected void setSpl() {
        this.spl = 2;
    }

    @Override
    protected void prepareRecombination() {
        ISpecies spc = this.context.getSpecies();
        if (!(spc instanceof ExprTreeSpecies)) {
            throw new IllegalStateException("Illegal species in context");
        }
        this.species = (ExprTreeSpecies)spc;
        this.schema = ((ExprTreeSpecies)spc).getGenotypeSchema();
    }

    @Override
    protected void recombineNext() {
        ExprTree p0_genotype = (ExprTree)((ExprTreeIndividual)this.parentsBuffer.get(this.parentsCounter)).getGenotype();
        ExprTree p1_genotype = (ExprTree)((ExprTreeIndividual)this.parentsBuffer.get(this.parentsCounter + 1)).getGenotype();
        ExprTree s0_genotype = new ExprTree();
        ExprTree s1_genotype = new ExprTree();
        this.baseOp.recombine(p0_genotype, p1_genotype, s0_genotype, s1_genotype, this.schema, this.randgen);
        this.sonsBuffer.add(this.species.createIndividual(s0_genotype));
        this.sonsBuffer.add(this.species.createIndividual(s1_genotype));
    }
}

