/*
 * Decompiled with CFR 0.152.
 */
package javolution.realtime;

import javax.realtime.MemoryArea;
import javax.realtime.RealtimeThread;
import javolution.Configuration;
import javolution.lang.Reflection;
import javolution.realtime.ConcurrentException;
import javolution.realtime.ConcurrentThread;
import javolution.realtime.Context;
import javolution.realtime.LocalReference;
import javolution.realtime.PoolContext;

public class ConcurrentContext
extends Context {
    private static final Class CLASS = Reflection.getClass("javolution.realtime.ConcurrentContext");
    private static final LocalReference ENABLED = new LocalReference<Boolean>(new Boolean(true));
    private int _activeCount;
    private Throwable _error;
    private ConcurrentThread[] _threads;
    private boolean _isEnabled;
    private static final Boolean TRUE = new Boolean(true);
    private static final Boolean FALSE = new Boolean(false);
    private final Object[] _args1 = new Object[1];
    private final Object[] _args2 = new Object[2];
    private final Object[] _args3 = new Object[3];
    private final Object[] _args4 = new Object[4];
    private final Object[] _args5 = new Object[5];
    private final Object[] _args6 = new Object[6];

    public ConcurrentContext() {
    }

    public ConcurrentContext(ConcurrentThread[] concurrentThreadArray) {
        this._threads = concurrentThreadArray;
    }

    public final ConcurrentThread[] getConcurrentThreads() {
        if (this._threads != null) {
            return this._threads;
        }
        for (Context context = this.getOuter(); context != null; context = context.getOuter()) {
            if (!(context instanceof ConcurrentContext)) continue;
            ConcurrentContext concurrentContext = (ConcurrentContext)context;
            if (concurrentContext._threads == null) continue;
            return concurrentContext._threads;
        }
        return null;
    }

    public void clear() {
        if (this._threads != null) {
            for (int i = 0; i < this._threads.length; ++i) {
                this._threads[i].terminate();
            }
            this._threads = null;
        }
    }

    public static ConcurrentContext current() {
        for (Context context = Context.current(); context != null; context = context.getOuter()) {
            if (!(context instanceof ConcurrentContext)) continue;
            return (ConcurrentContext)context;
        }
        return null;
    }

    public static void enter() {
        Context.enter(CLASS);
    }

    public static void exit() {
        Context.exit(CLASS);
    }

    public static void setEnabled(boolean bl) {
        ENABLED.set(bl ? TRUE : FALSE);
    }

    public static boolean isEnabled() {
        return (Boolean)ENABLED.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Logic logic) {
        ConcurrentContext concurrentContext = ConcurrentContext.current();
        if (concurrentContext._isEnabled) {
            ConcurrentThread[] concurrentThreadArray = concurrentContext.getConcurrentThreads();
            MemoryArea memoryArea = RealtimeThread.getCurrentMemoryArea();
            for (int i = 0; i < concurrentThreadArray.length; ++i) {
                if (!concurrentThreadArray[i].execute(logic, concurrentContext, memoryArea)) continue;
                ConcurrentContext concurrentContext2 = concurrentContext;
                synchronized (concurrentContext2) {
                    ++concurrentContext._activeCount;
                    return;
                }
            }
        }
        concurrentContext.executeByCurrentThread(logic, Logic.NO_ARG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Logic logic, Object object) {
        ConcurrentContext concurrentContext = ConcurrentContext.current();
        if (concurrentContext._isEnabled) {
            ConcurrentThread[] concurrentThreadArray = concurrentContext.getConcurrentThreads();
            MemoryArea memoryArea = RealtimeThread.getCurrentMemoryArea();
            for (int i = 0; i < concurrentThreadArray.length; ++i) {
                if (!concurrentThreadArray[i].execute(logic, object, concurrentContext, memoryArea)) continue;
                ConcurrentContext concurrentContext2 = concurrentContext;
                synchronized (concurrentContext2) {
                    ++concurrentContext._activeCount;
                    return;
                }
            }
        }
        concurrentContext._args1[0] = object;
        concurrentContext.executeByCurrentThread(logic, concurrentContext._args1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Logic logic, Object object, Object object2) {
        ConcurrentContext concurrentContext = ConcurrentContext.current();
        if (concurrentContext._isEnabled) {
            ConcurrentThread[] concurrentThreadArray = concurrentContext.getConcurrentThreads();
            MemoryArea memoryArea = RealtimeThread.getCurrentMemoryArea();
            for (int i = 0; i < concurrentThreadArray.length; ++i) {
                if (!concurrentThreadArray[i].execute(logic, object, object2, concurrentContext, memoryArea)) continue;
                ConcurrentContext concurrentContext2 = concurrentContext;
                synchronized (concurrentContext2) {
                    ++concurrentContext._activeCount;
                    return;
                }
            }
        }
        concurrentContext._args2[0] = object;
        concurrentContext._args2[1] = object2;
        concurrentContext.executeByCurrentThread(logic, concurrentContext._args2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Logic logic, Object object, Object object2, Object object3) {
        ConcurrentContext concurrentContext = ConcurrentContext.current();
        if (concurrentContext._isEnabled) {
            ConcurrentThread[] concurrentThreadArray = concurrentContext.getConcurrentThreads();
            MemoryArea memoryArea = RealtimeThread.getCurrentMemoryArea();
            for (int i = 0; i < concurrentThreadArray.length; ++i) {
                if (!concurrentThreadArray[i].execute(logic, object, object2, object3, concurrentContext, memoryArea)) continue;
                ConcurrentContext concurrentContext2 = concurrentContext;
                synchronized (concurrentContext2) {
                    ++concurrentContext._activeCount;
                    return;
                }
            }
        }
        concurrentContext._args3[0] = object;
        concurrentContext._args3[1] = object2;
        concurrentContext._args3[2] = object3;
        concurrentContext.executeByCurrentThread(logic, concurrentContext._args3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Logic logic, Object object, Object object2, Object object3, Object object4) {
        ConcurrentContext concurrentContext = ConcurrentContext.current();
        if (concurrentContext._isEnabled) {
            ConcurrentThread[] concurrentThreadArray = concurrentContext.getConcurrentThreads();
            MemoryArea memoryArea = RealtimeThread.getCurrentMemoryArea();
            for (int i = 0; i < concurrentThreadArray.length; ++i) {
                if (!concurrentThreadArray[i].execute(logic, object, object2, object3, object4, concurrentContext, memoryArea)) continue;
                ConcurrentContext concurrentContext2 = concurrentContext;
                synchronized (concurrentContext2) {
                    ++concurrentContext._activeCount;
                    return;
                }
            }
        }
        concurrentContext._args4[0] = object;
        concurrentContext._args4[1] = object2;
        concurrentContext._args4[2] = object3;
        concurrentContext._args4[3] = object4;
        concurrentContext.executeByCurrentThread(logic, concurrentContext._args4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Logic logic, Object object, Object object2, Object object3, Object object4, Object object5) {
        ConcurrentContext concurrentContext = ConcurrentContext.current();
        if (concurrentContext._isEnabled) {
            ConcurrentThread[] concurrentThreadArray = concurrentContext.getConcurrentThreads();
            MemoryArea memoryArea = RealtimeThread.getCurrentMemoryArea();
            for (int i = 0; i < concurrentThreadArray.length; ++i) {
                if (!concurrentThreadArray[i].execute(logic, object, object2, object3, object4, object5, concurrentContext, memoryArea)) continue;
                ConcurrentContext concurrentContext2 = concurrentContext;
                synchronized (concurrentContext2) {
                    ++concurrentContext._activeCount;
                    return;
                }
            }
        }
        concurrentContext._args5[0] = object;
        concurrentContext._args5[1] = object2;
        concurrentContext._args5[2] = object3;
        concurrentContext._args5[3] = object4;
        concurrentContext._args5[4] = object5;
        concurrentContext.executeByCurrentThread(logic, concurrentContext._args5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Logic logic, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        ConcurrentContext concurrentContext = ConcurrentContext.current();
        if (concurrentContext._isEnabled) {
            ConcurrentThread[] concurrentThreadArray = concurrentContext.getConcurrentThreads();
            MemoryArea memoryArea = RealtimeThread.getCurrentMemoryArea();
            for (int i = 0; i < concurrentThreadArray.length; ++i) {
                if (!concurrentThreadArray[i].execute(logic, object, object2, object3, object4, object5, object6, concurrentContext, memoryArea)) continue;
                ConcurrentContext concurrentContext2 = concurrentContext;
                synchronized (concurrentContext2) {
                    ++concurrentContext._activeCount;
                    return;
                }
            }
        }
        concurrentContext._args6[0] = object;
        concurrentContext._args6[1] = object2;
        concurrentContext._args6[2] = object3;
        concurrentContext._args6[3] = object4;
        concurrentContext._args6[4] = object5;
        concurrentContext._args6[5] = object6;
        concurrentContext.executeByCurrentThread(logic, concurrentContext._args6);
    }

    protected void enterAction() {
        this._error = null;
        this._activeCount = 0;
        this._isEnabled = ConcurrentContext.isEnabled();
        if (this.getConcurrentThreads() == null) {
            MemoryArea memoryArea = MemoryArea.getMemoryArea(this);
            memoryArea.executeInArea(new Runnable(){

                public void run() {
                    ConcurrentContext.access$102(ConcurrentContext.this, new ConcurrentThread[Configuration.concurrency()]);
                    for (int i = 0; i < ConcurrentContext.this._threads.length; ++i) {
                        ((ConcurrentContext)ConcurrentContext.this)._threads[i] = new ConcurrentThread();
                        ConcurrentContext.this._threads[i].start();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exitAction() {
        ConcurrentContext concurrentContext = this;
        synchronized (concurrentContext) {
            while (this._activeCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new ConcurrentException(interruptedException);
                }
            }
        }
        if (this._error != null) {
            throw new ConcurrentException(this._error);
        }
    }

    synchronized void setError(Throwable throwable) {
        if (this._error == null) {
            this._error = throwable;
        }
    }

    synchronized void decreaseActiveCount() {
        --this._activeCount;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeByCurrentThread(Logic logic, Object[] objectArray) {
        PoolContext.enter();
        try {
            logic.run(objectArray);
        }
        catch (Throwable throwable) {
            try {
                this.setError(throwable);
            }
            catch (Throwable throwable2) {
                PoolContext.exit();
                int n = 0;
                while (n < objectArray.length) {
                    objectArray[n++] = null;
                }
                throw throwable2;
            }
            PoolContext.exit();
            int n = 0;
            while (n < objectArray.length) {
                objectArray[n++] = null;
            }
        }
        PoolContext.exit();
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n++] = null;
        }
    }

    static /* synthetic */ ConcurrentThread[] access$102(ConcurrentContext concurrentContext, ConcurrentThread[] concurrentThreadArray) {
        concurrentContext._threads = concurrentThreadArray;
        return concurrentThreadArray;
    }

    public static abstract class Logic
    implements Runnable {
        private static final Object[] NO_ARG = new Object[0];

        public final void run() {
            this.run(NO_ARG);
        }

        public abstract void run(Object[] var1);
    }
}

