/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.M5;

import java.io.Serializable;
import java.util.Enumeration;
import keel.Algorithms.Decision_Trees.M5.M5Attribute;
import keel.Algorithms.Decision_Trees.M5.M5Instances;
import keel.Algorithms.Decision_Trees.M5.M5StaticUtils;

public class M5Instance
implements Serializable {
    protected static final double MISSING_VALUE = Double.NaN;
    protected M5Instances m_Dataset;
    protected double[] m_AttValues;
    protected double m_Weight;

    public M5Instance(M5Instance instance) {
        this.m_AttValues = instance.m_AttValues;
        this.m_Weight = instance.m_Weight;
        this.m_Dataset = null;
    }

    public M5Instance(double weight, double[] attValues) {
        this.m_AttValues = attValues;
        this.m_Weight = weight;
        this.m_Dataset = null;
    }

    public M5Instance(int numAttributes) {
        this.m_AttValues = new double[numAttributes];
        for (int i = 0; i < this.m_AttValues.length; ++i) {
            this.m_AttValues[i] = Double.NaN;
        }
        this.m_Weight = 1.0;
        this.m_Dataset = null;
    }

    public M5Attribute attribute(int index) throws Exception {
        if (this.m_Dataset == null) {
            throw new Exception("M5Instace doesn't have access to a dataset!");
        }
        return this.m_Dataset.attribute(index);
    }

    public M5Attribute attributeSparse(int indexOfIndex) throws Exception {
        if (this.m_Dataset == null) {
            throw new Exception("M5Instace doesn't have access to a dataset!");
        }
        return this.m_Dataset.attribute(indexOfIndex);
    }

    public M5Attribute classAttribute() throws Exception {
        if (this.m_Dataset == null) {
            throw new Exception("M5Instace doesn't have access to a dataset!");
        }
        return this.m_Dataset.classAttribute();
    }

    public int classIndex() throws Exception {
        if (this.m_Dataset == null) {
            throw new Exception("M5Instace doesn't have access to a dataset!");
        }
        return this.m_Dataset.classIndex();
    }

    public boolean classIsMissing() throws Exception {
        if (this.classIndex() < 0) {
            throw new Exception("Class is not set!");
        }
        return this.isMissing(this.classIndex());
    }

    public double classValue() throws Exception {
        if (this.classIndex() < 0) {
            throw new Exception("Class is not set!");
        }
        return this.value(this.classIndex());
    }

    public Object copy() {
        M5Instance result = new M5Instance(this);
        result.m_Dataset = this.m_Dataset;
        return result;
    }

    public M5Instances dataset() {
        return this.m_Dataset;
    }

    public void deleteAttributeAt(int position) {
        if (this.m_Dataset != null) {
            throw new RuntimeException("M5Instace has access to a dataset!");
        }
        this.forceDeleteAttributeAt(position);
    }

    public Enumeration enumerateAttributes() throws Exception {
        if (this.m_Dataset == null) {
            throw new Exception("M5Instace doesn't have access to a dataset!");
        }
        return this.m_Dataset.enumerateAttributes();
    }

    public boolean equalHeaders(M5Instance inst) throws Exception {
        if (this.m_Dataset == null) {
            throw new Exception("M5Instace doesn't have access to a dataset!");
        }
        return this.m_Dataset.equalHeaders(inst.m_Dataset);
    }

    public int index(int position) {
        return position;
    }

    public void insertAttributeAt(int position) {
        if (this.m_Dataset != null) {
            throw new RuntimeException("M5Instace has accesss to a dataset!");
        }
        if (position < 0 || position > this.numAttributes()) {
            throw new IllegalArgumentException("Can't insert attribute: index out of range");
        }
        this.forceInsertAttributeAt(position);
    }

    public boolean isMissing(int attIndex) {
        return Double.isNaN(this.m_AttValues[attIndex]);
    }

    public boolean isMissingSparse(int indexOfIndex) {
        return Double.isNaN(this.m_AttValues[indexOfIndex]);
    }

    public boolean isMissing(M5Attribute att) {
        return this.isMissing(att.index());
    }

    public static boolean isMissingValue(double val) {
        return Double.isNaN(val);
    }

    public M5Instance mergeInstance(M5Instance inst) {
        int m = 0;
        double[] newVals = new double[this.numAttributes() + inst.numAttributes()];
        int j = 0;
        while (j < this.numAttributes()) {
            newVals[m] = this.value(j);
            ++j;
            ++m;
        }
        j = 0;
        while (j < inst.numAttributes()) {
            newVals[m] = inst.value(j);
            ++j;
            ++m;
        }
        return new M5Instance(1.0, newVals);
    }

    public static double missingValue() {
        return Double.NaN;
    }

    public int numAttributes() {
        return this.m_AttValues.length;
    }

    public int numClasses() throws Exception {
        if (this.m_Dataset == null) {
            throw new Exception("M5Instace doesn't have access to a dataset!");
        }
        return this.m_Dataset.numClasses();
    }

    public int numValues() {
        return this.m_AttValues.length;
    }

    public void replaceMissingValues(double[] array) {
        if (array == null || array.length != this.m_AttValues.length) {
            throw new IllegalArgumentException("Unequal number of attributes!");
        }
        this.freshAttributeVector();
        for (int i = 0; i < this.m_AttValues.length; ++i) {
            if (!this.isMissing(i)) continue;
            this.m_AttValues[i] = array[i];
        }
    }

    public void setClassMissing() throws Exception {
        if (this.classIndex() < 0) {
            throw new Exception("Class is not set!");
        }
        this.setMissing(this.classIndex());
    }

    public void setClassValue(double value) throws Exception {
        if (this.classIndex() < 0) {
            throw new Exception("Class is not set!");
        }
        this.setValue(this.classIndex(), value);
    }

    public final void setClassValue(String value) throws Exception {
        if (this.classIndex() < 0) {
            throw new Exception("Class is not set!");
        }
        this.setValue(this.classIndex(), value);
    }

    public final void setDataset(M5Instances instances) {
        this.m_Dataset = instances;
    }

    public final void setMissing(int attIndex) {
        this.setValue(attIndex, Double.NaN);
    }

    public final void setMissing(M5Attribute att) {
        this.setMissing(att.index());
    }

    public void setValue(int attIndex, double value) {
        this.freshAttributeVector();
        this.m_AttValues[attIndex] = value;
    }

    public void setValueSparse(int indexOfIndex, double value) {
        this.freshAttributeVector();
        this.m_AttValues[indexOfIndex] = value;
    }

    public final void setValue(int attIndex, String value) throws Exception {
        if (this.m_Dataset == null) {
            throw new Exception("M5Instace doesn't have access to a dataset!");
        }
        if (!this.attribute(attIndex).isNominal() && !this.attribute(attIndex).isString()) {
            throw new IllegalArgumentException("Attribute neither nominal nor string!");
        }
        int valIndex = this.attribute(attIndex).indexOfValue(value);
        if (valIndex == -1) {
            if (this.attribute(attIndex).isNominal()) {
                throw new IllegalArgumentException("Value not defined for given nominal attribute!");
            }
            this.attribute(attIndex).forceAddValue(value);
            valIndex = this.attribute(attIndex).indexOfValue(value);
        }
        this.setValue(attIndex, (double)valIndex);
    }

    public final void setValue(M5Attribute att, double value) {
        this.setValue(att.index(), value);
    }

    public final void setValue(M5Attribute att, String value) {
        if (!att.isNominal() && !att.isString()) {
            throw new IllegalArgumentException("Attribute neither nominal nor string!");
        }
        int valIndex = att.indexOfValue(value);
        if (valIndex == -1) {
            if (att.isNominal()) {
                throw new IllegalArgumentException("Value not defined for given nominal attribute!");
            }
            att.forceAddValue(value);
            valIndex = att.indexOfValue(value);
        }
        this.setValue(att.index(), (double)valIndex);
    }

    public final void setWeight(double weight) {
        this.m_Weight = weight;
    }

    public final String stringValue(int attIndex) throws Exception {
        if (this.m_Dataset == null) {
            throw new Exception("M5Instace doesn't have access to a dataset!");
        }
        if (!this.m_Dataset.attribute(attIndex).isNominal() && !this.m_Dataset.attribute(attIndex).isString()) {
            throw new IllegalArgumentException("Attribute neither nominal nor string!");
        }
        return this.m_Dataset.attribute(attIndex).value((int)this.value(attIndex));
    }

    public final String stringValue(M5Attribute att) throws Exception {
        return this.stringValue(att.index());
    }

    public double[] toDoubleArray() {
        double[] newValues = new double[this.m_AttValues.length];
        System.arraycopy(this.m_AttValues, 0, newValues, 0, this.m_AttValues.length);
        return newValues;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < this.m_AttValues.length; ++i) {
            if (i > 0) {
                text.append(",");
            }
            try {
                text.append(this.toString(i));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return text.toString();
    }

    public final String toString(int attIndex) throws Exception {
        StringBuffer text = new StringBuffer();
        if (this.isMissing(attIndex)) {
            text.append("?");
        } else if (this.m_Dataset == null) {
            text.append(M5StaticUtils.doubleToString(this.m_AttValues[attIndex], 6));
        } else if (this.m_Dataset.attribute(attIndex).isNominal() || this.m_Dataset.attribute(attIndex).isString()) {
            text.append(M5StaticUtils.quote(this.stringValue(attIndex)));
        } else {
            text.append(M5StaticUtils.doubleToString(this.value(attIndex), 6));
        }
        return text.toString();
    }

    public final String toString(M5Attribute att) throws Exception {
        return this.toString(att.index());
    }

    public double value(int attIndex) {
        return this.m_AttValues[attIndex];
    }

    public double valueSparse(int indexOfIndex) {
        return this.m_AttValues[indexOfIndex];
    }

    public double value(M5Attribute att) {
        return this.value(att.index());
    }

    public final double weight() {
        return this.m_Weight;
    }

    void forceDeleteAttributeAt(int position) {
        double[] newValues = new double[this.m_AttValues.length - 1];
        System.arraycopy(this.m_AttValues, 0, newValues, 0, position);
        if (position < this.m_AttValues.length - 1) {
            System.arraycopy(this.m_AttValues, position + 1, newValues, position, this.m_AttValues.length - (position + 1));
        }
        this.m_AttValues = newValues;
    }

    void forceInsertAttributeAt(int position) {
        double[] newValues = new double[this.m_AttValues.length + 1];
        System.arraycopy(this.m_AttValues, 0, newValues, 0, position);
        newValues[position] = Double.NaN;
        System.arraycopy(this.m_AttValues, position, newValues, position + 1, this.m_AttValues.length - position);
        this.m_AttValues = newValues;
    }

    protected M5Instance() {
    }

    private void freshAttributeVector() {
        this.m_AttValues = this.toDoubleArray();
    }
}

