/*
 * Decompiled with CFR 0.152.
 */
package org.flsgen.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import org.flsgen.grid.neighborhood.INeighborhood;
import org.flsgen.grid.regular.square.RegularSquareGrid;

public class RasterConnectivityFinder {
    private int n = 0;
    private int[] values;
    private int[][] neighs;
    private long npro;
    private int[] CCFirstNode;
    private int[] CCNextNode;
    private int[] nodeCC;
    private int[] parent;
    private int[] fifo;
    private int[] sizeCC;
    private int nbCC;
    private int sizeMinCC;
    private int sizeMaxCC;
    Map<Integer, Integer> graphIdxToRasterIdx;
    Map<Integer, Integer> rasterIdxToGraphIdx;
    private int classValue;

    public RasterConnectivityFinder(int nbRows, int nbCols, int[] values, int classValue, INeighborhood neighborhood) {
        int i;
        this.values = values;
        this.classValue = classValue;
        RegularSquareGrid grid = new RegularSquareGrid(nbRows, nbCols);
        int currentIdx = 0;
        this.graphIdxToRasterIdx = new HashMap<Integer, Integer>();
        this.rasterIdxToGraphIdx = new HashMap<Integer, Integer>();
        for (i = 0; i < values.length; ++i) {
            if (values[i] != classValue) continue;
            ++this.n;
            this.rasterIdxToGraphIdx.put(i, currentIdx);
            this.graphIdxToRasterIdx.put(currentIdx, i);
            ++currentIdx;
        }
        this.neighs = new int[this.n][];
        currentIdx = 0;
        for (i = 0; i < values.length; ++i) {
            if (values[i] != classValue) continue;
            this.neighs[currentIdx] = IntStream.of(neighborhood.getNeighbors(grid, i)).filter(v -> values[v] == classValue).map(v -> this.rasterIdxToGraphIdx.get(v)).toArray();
            ++currentIdx;
        }
        this.parent = new int[this.n];
        this.fifo = new int[this.n];
    }

    public int getNbNodes() {
        return this.n;
    }

    public int getNBCC() {
        return this.nbCC;
    }

    public int getSizeMinCC() {
        return this.sizeMinCC;
    }

    public int getSizeMaxCC() {
        return this.sizeMaxCC;
    }

    public int[] getSizeCC() {
        return this.sizeCC;
    }

    public int[] getCCFirstNode() {
        return this.CCFirstNode;
    }

    public int[] getCCNextNode() {
        return this.CCNextNode;
    }

    public int[] getNodeCC() {
        return this.nodeCC;
    }

    public void findAllCC() {
        int i;
        if (this.nodeCC == null) {
            this.CCFirstNode = new int[this.n];
            this.CCNextNode = new int[this.n];
            this.nodeCC = new int[this.n];
            this.sizeCC = new int[this.n];
        }
        this.sizeMinCC = 0;
        this.sizeMaxCC = 0;
        this.npro = 0L;
        for (i = 0; i < this.n; ++i) {
            this.parent[i] = -1;
        }
        for (i = 0; i < this.CCFirstNode.length; ++i) {
            this.CCFirstNode[i] = -1;
            this.sizeCC[i] = -1;
        }
        int cc = 0;
        for (int i2 = 0; i2 < this.n; ++i2) {
            if (this.parent[i2] != -1) continue;
            this.findCC(i2, cc);
            if (this.sizeMinCC == 0 || this.sizeMinCC > this.sizeCC[cc]) {
                this.sizeMinCC = this.sizeCC[cc];
            }
            if (this.sizeMaxCC < this.sizeCC[cc]) {
                this.sizeMaxCC = this.sizeCC[cc];
            }
            this.npro += Long.valueOf(this.sizeCC[cc]) * Long.valueOf(this.sizeCC[cc]);
            ++cc;
        }
        this.nbCC = cc;
    }

    private void findCC(int start, int cc) {
        int first = 0;
        int last = 0;
        int size = 1;
        this.fifo[last++] = start;
        this.parent[start] = start;
        this.add(start, cc);
        while (first < last) {
            int i = this.fifo[first++];
            for (int j : this.neighs[i]) {
                if (this.parent[j] != -1) continue;
                this.parent[j] = i;
                this.add(j, cc);
                ++size;
                this.fifo[last++] = j;
            }
        }
        this.sizeCC[cc] = size;
    }

    private void add(int node, int cc) {
        this.nodeCC[node] = cc;
        this.CCNextNode[node] = this.CCFirstNode[cc];
        this.CCFirstNode[cc] = node;
    }

    public int[] getCC(int ccIndex) {
        int[] cc = new int[this.sizeCC[ccIndex]];
        int j = 0;
        int i = this.getCCFirstNode()[ccIndex];
        while (i != -1) {
            cc[j++] = this.graphIdxToRasterIdx.get(i);
            i = this.getCCNextNode()[i];
        }
        return cc;
    }

    public long getNpro() {
        return this.npro;
    }
}

