/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.ternary;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableBitSet;

public class PropModXYZ
extends Propagator<IntVar> {
    private final IntVar x;
    private final IntVar y;
    private final IntVar z;
    private IntIterableBitSet usedValues;

    public PropModXYZ(IntVar x, IntVar y, IntVar z) {
        super((Variable[])new IntVar[]{x, y, z}, (Priority)PropagatorPriority.TERNARY, false);
        this.x = x;
        this.y = y;
        this.z = z;
        if (z.hasEnumeratedDomain()) {
            this.usedValues = new IntIterableBitSet();
            this.usedValues.setOffset(z.getLB());
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.z.getLB() < 0) {
            this.z.updateLowerBound(-(Math.max(Math.abs(this.y.getLB()), this.y.getUB()) - 1), (ICause)this);
        }
        if (this.z.getUB() > 0) {
            this.z.updateUpperBound(Math.max(Math.abs(this.y.getLB()), this.y.getUB()) - 1, (ICause)this);
        }
        if (this.x.getUB() <= 0) {
            this.z.updateUpperBound(0, (ICause)this);
        }
        if (this.x.getLB() >= 0) {
            this.z.updateLowerBound(0, (ICause)this);
        }
        if (this.y.hasEnumeratedDomain()) {
            this.y.removeValue(0, (ICause)this);
        }
        if (this.x.hasEnumeratedDomain() && this.y.hasEnumeratedDomain() && this.z.hasEnumeratedDomain()) {
            this.propagateEnumerated();
        } else {
            this.propagateBounded();
        }
    }

    private void propagateEnumerated() throws ContradictionException {
        this.usedValues.clear();
        int vx = this.x.getLB();
        while (vx <= this.x.getUB()) {
            boolean toRemove = true;
            int vy = this.y.getLB();
            while (vy <= this.y.getUB()) {
                if (vy != 0 && this.z.contains(vx % vy)) {
                    this.usedValues.add(vx % vy);
                    toRemove = false;
                }
                vy = this.y.nextValue(vy);
            }
            if (toRemove) {
                this.x.removeValue(vx, (ICause)this);
            }
            vx = this.x.nextValue(vx);
        }
        this.z.removeAllValuesBut(this.usedValues, this);
        int vy = this.y.getLB();
        while (vy <= this.y.getUB()) {
            if (!PropModXYZ.containsOneDivid(this.x, vy, this.z)) {
                this.y.removeValue(vy, (ICause)this);
            }
            vy = this.y.nextValue(vy);
        }
    }

    private void propagateBounded() throws ContradictionException {
        boolean hasChange = true;
        while (hasChange) {
            hasChange = false;
            while (!PropModXYZ.containsOneDivid(this.x.getLB(), this.y, this.z)) {
                this.x.updateLowerBound(this.x.getLB() + 1, (ICause)this);
                hasChange = true;
            }
            while (!PropModXYZ.containsOneDivid(this.x.getUB(), this.y, this.z)) {
                this.x.updateUpperBound(this.x.getUB() - 1, (ICause)this);
                hasChange = true;
            }
            while (!PropModXYZ.containsOneDivid(this.x, this.y, this.z.getLB())) {
                this.z.updateLowerBound(this.z.getLB() + 1, (ICause)this);
                hasChange = true;
            }
            while (!PropModXYZ.containsOneDivid(this.x, this.y, this.z.getUB())) {
                this.z.updateUpperBound(this.z.getUB() - 1, (ICause)this);
                hasChange = true;
            }
            while (this.y.getLB() == 0 || !PropModXYZ.containsOneDivid(this.x, this.y.getLB(), this.z)) {
                this.y.updateLowerBound(this.y.getLB() + 1, (ICause)this);
                hasChange = true;
            }
            while (this.y.getUB() == 0 || !PropModXYZ.containsOneDivid(this.x, this.y.getUB(), this.z)) {
                this.y.updateUpperBound(this.y.getUB() - 1, (ICause)this);
                hasChange = true;
            }
        }
    }

    private static boolean containsOneDivid(int v, IntVar Y, IntVar Z) {
        int vy = Y.getLB();
        while (vy <= Y.getUB()) {
            if (vy != 0) {
                int vz = Z.getLB();
                while (vz <= Z.getUB()) {
                    if (v % vy == vz) {
                        return true;
                    }
                    vz = Z.nextValue(vz);
                }
            }
            vy = Y.nextValue(vy);
        }
        return false;
    }

    private static boolean containsOneDivid(IntVar X, int v, IntVar Z) {
        if (v != 0) {
            int vx = X.getLB();
            while (vx <= X.getUB()) {
                int vz = Z.getLB();
                while (vz <= Z.getUB()) {
                    if (vx % v == vz) {
                        return true;
                    }
                    vz = Z.nextValue(vz);
                }
                vx = X.nextValue(vx);
            }
        }
        return false;
    }

    private static boolean containsOneDivid(IntVar X, IntVar Y, int v) {
        int vx = X.getLB();
        while (vx <= X.getUB()) {
            int vy = Y.getLB();
            while (vy <= Y.getUB()) {
                if (vy != 0 && vx % vy == v) {
                    return true;
                }
                vy = Y.nextValue(vy);
            }
            vx = X.nextValue(vx);
        }
        return false;
    }

    @Override
    public ESat isEntailed() {
        if (this.x.isInstantiated() && this.y.isInstantiated() && this.z.isInstantiated()) {
            return this.y.getValue() != 0 && this.x.getValue() % this.y.getValue() == this.z.getValue() ? ESat.TRUE : ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return this.x.getName() + " % " + this.y.getName() + " = " + this.z.getName();
    }
}

