/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.circuit;

import java.util.Random;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.nary.circuit.CircuitConf;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.graphOperations.connectivity.StrongConnectivityFinder;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class PropCircuitSCC
extends Propagator<IntVar> {
    private final int n;
    private final int n2;
    private final DirectedGraph support;
    private final StrongConnectivityFinder SCCfinder;
    private final DirectedGraph G_R;
    private int[] sccOf;
    private final ISet[] mates;
    private Random rd;
    private final int offSet;
    private final CircuitConf conf;

    public PropCircuitSCC(IntVar[] succs, int offSet, CircuitConf conf) {
        super((Variable[])succs, (Priority)PropagatorPriority.LINEAR, false);
        this.offSet = offSet;
        this.n = ((IntVar[])this.vars).length;
        this.n2 = this.n + 1;
        this.support = new DirectedGraph(this.n2, SetType.BITSET, true);
        this.G_R = new DirectedGraph(this.n2, SetType.LINKED_LIST, false);
        this.SCCfinder = new StrongConnectivityFinder(this.support);
        this.mates = new ISet[this.n2];
        for (int i = 0; i < this.n2; ++i) {
            this.mates[i] = SetFactory.makeLinkedList();
        }
        this.conf = conf;
        if (conf == CircuitConf.RD) {
            this.rd = new Random(((IntVar[])this.vars)[0].getModel().getSeed());
        }
    }

    @Override
    public ESat isEntailed() {
        return ESat.TRUE;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            for (i = 0; i < this.n; ++i) {
                ((IntVar[])this.vars)[i].updateBounds(this.offSet, this.n - 1 + this.offSet, this);
            }
        }
        switch (this.conf) {
            case FIRST: {
                this.filterFromSource(0);
                break;
            }
            default: {
                this.filterFromSource(this.rd.nextInt(this.n));
                break;
            }
            case ALL: {
                for (i = 0; i < this.n; ++i) {
                    this.filterFromSource(i);
                }
            }
        }
    }

    public void filterFromSource(int source) throws ContradictionException {
        int i;
        this.rebuild(source);
        int first = -1;
        int last = -1;
        int n_R = this.SCCfinder.getNbSCC();
        for (i = 0; i < n_R; ++i) {
            if (this.G_R.getPredecessorsOf(i).isEmpty()) {
                if (first != -1) {
                    this.fails();
                }
                first = i;
            }
            if (!this.G_R.getSuccessorsOf(i).isEmpty()) continue;
            if (last != -1) {
                this.fails();
            }
            last = i;
        }
        if (first == -1 || last == -1 || first == last) {
            this.fails();
        }
        if (this.visit(first, last, source) != n_R) {
            this.fails();
        }
        this.filterFromInst(source);
        for (i = 0; i < n_R; ++i) {
            this.checkSCCLink(i);
        }
    }

    public void rebuild(int source) {
        int j;
        int i;
        for (i = 0; i < this.n2; ++i) {
            this.mates[i].clear();
            this.support.getSuccessorsOf(i).clear();
            this.support.getPredecessorsOf(i).clear();
            this.G_R.getPredecessorsOf(i).clear();
            this.G_R.getSuccessorsOf(i).clear();
        }
        this.G_R.getNodes().clear();
        for (i = 0; i < this.n; ++i) {
            IntVar v = ((IntVar[])this.vars)[i];
            int lb = v.getLB();
            int ub = v.getUB();
            j = lb;
            while (j <= ub) {
                if (j - this.offSet == source) {
                    this.support.addEdge(i, this.n);
                } else {
                    this.support.addEdge(i, j - this.offSet);
                }
                j = v.nextValue(j);
            }
        }
        this.SCCfinder.findAllSCC();
        int n_R = this.SCCfinder.getNbSCC();
        for (int i2 = 0; i2 < n_R; ++i2) {
            this.G_R.getNodes().add(i2);
        }
        this.sccOf = this.SCCfinder.getNodesSCC();
        for (int i3 = 0; i3 < this.n; ++i3) {
            int x = this.sccOf[i3];
            ISetIterator succs = this.support.getSuccessorsOf(i3).iterator();
            while (succs.hasNext()) {
                j = succs.nextInt();
                if (x == this.sccOf[j]) continue;
                this.G_R.addEdge(x, this.sccOf[j]);
                this.mates[x].add((i3 + 1) * this.n2 + j);
            }
        }
    }

    private int visit(int node, int last, int source) throws ContradictionException {
        if (node == -1) {
            this.fails();
        }
        if (node == last) {
            return 1;
        }
        int next = -1;
        ISetIterator succs = this.G_R.getSuccessorsOf(node).iterator();
        while (succs.hasNext()) {
            int x = succs.nextInt();
            if (this.G_R.getPredecessorsOf(x).size() == 1) {
                if (next != -1) {
                    return 0;
                }
                next = x;
                continue;
            }
            this.G_R.removeEdge(node, x);
        }
        succs = this.mates[node].iterator();
        while (succs.hasNext()) {
            int e = succs.nextInt();
            int to = e % this.n2;
            if (this.sccOf[to] == next) continue;
            int from = e / this.n2 - 1;
            if (to == this.n) {
                to = source;
            }
            ((IntVar[])this.vars)[from].removeValue(to + this.offSet, (ICause)this);
            this.mates[node].remove(e);
        }
        return this.visit(next, last, source) + 1;
    }

    private void filterFromInst(int source) throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            if (!((IntVar[])this.vars)[i].isInstantiated()) continue;
            int to = ((IntVar[])this.vars)[i].getValue() - this.offSet;
            int x = this.sccOf[i];
            if (to == source) {
                to = this.n;
            }
            if (to == -1 || this.sccOf[to] == x || this.mates[x].size() <= 1) continue;
            int arc = (i + 1) * this.n2 + to;
            ISetIterator iter = this.mates[x].iterator();
            while (iter.hasNext()) {
                int a2 = iter.nextInt();
                if (a2 == arc) continue;
                int val = a2 % this.n2;
                if (val == this.n) {
                    val = source;
                }
                ((IntVar[])this.vars)[a2 / this.n2 - 1].removeValue(val + this.offSet, (ICause)this);
            }
            this.mates[x].clear();
            this.mates[x].add(arc);
        }
    }

    private void checkSCCLink(int sccFrom) throws ContradictionException {
        int inDoor = -1;
        int outDoor = -1;
        ISetIterator iter = this.mates[sccFrom].iterator();
        while (iter.hasNext()) {
            int i = iter.nextInt();
            if (inDoor == -1) {
                inDoor = i % this.n2;
            } else if (inDoor != i % this.n2) {
                inDoor = -2;
            }
            if (outDoor == -1) {
                outDoor = i / this.n2 - 1;
                continue;
            }
            if (outDoor == i / this.n2 - 1) continue;
            outDoor = -2;
        }
        if (inDoor >= 0) {
            this.forceInDoor(inDoor);
        }
        if (outDoor >= 0) {
            this.forceOutDoor(outDoor);
            if (this.G_R.getPredecessorsOf(sccFrom).iterator().hasNext()) {
                int in = -1;
                int p = this.G_R.getPredecessorsOf(sccFrom).iterator().next();
                ISetIterator iterP = this.mates[p].iterator();
                while (iterP.hasNext()) {
                    int i = iterP.nextInt();
                    if (in == -1) {
                        in = i % this.n2;
                        continue;
                    }
                    if (in == i % this.n2) continue;
                    return;
                }
                assert (in != -1);
                assert (this.sccOf[in] == sccFrom);
                if (((IntVar[])this.vars)[in].contains(outDoor + this.offSet)) {
                    int size;
                    int i = this.SCCfinder.getSCCFirstNode(sccFrom);
                    for (size = 0; i >= 0 && size < 3; ++size) {
                        i = this.SCCfinder.getNextNode(i);
                    }
                    if (size > 2) {
                        ((IntVar[])this.vars)[in].removeValue(outDoor + this.offSet, (ICause)this);
                    }
                }
            }
        }
    }

    private void forceInDoor(int x) throws ContradictionException {
        int sx = this.sccOf[x];
        for (int i = 0; i < this.n; ++i) {
            if (this.sccOf[i] != sx) continue;
            ((IntVar[])this.vars)[i].removeValue(x + this.offSet, (ICause)this);
        }
    }

    private void forceOutDoor(int x) throws ContradictionException {
        int sx = this.sccOf[x];
        int lb = ((IntVar[])this.vars)[x].getLB();
        int ub = ((IntVar[])this.vars)[x].getUB();
        int v = lb;
        while (v <= ub) {
            if (this.sccOf[v - this.offSet] == sx) {
                ((IntVar[])this.vars)[x].removeValue(v, (ICause)this);
            }
            v = ((IntVar[])this.vars)[x].nextValue(v);
        }
    }
}

