/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.ringsearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.openscience.cdk.ringsearch.CyclicVertexSearch;

class JumboCyclicVertexSearch
implements CyclicVertexSearch {
    private final int[][] g;
    private final BitSet cyclic;
    private final List<BitSet> cycles = new ArrayList<BitSet>(1);
    private final List<Boolean> fused = new ArrayList<Boolean>(1);
    private BitSet visited;
    private BitSet[] state;
    private int[] colors;
    private int numCycles = 0;
    private final Object lock = new Object();

    JumboCyclicVertexSearch(int[][] graph) {
        this.g = graph;
        int n = graph.length;
        this.cyclic = new BitSet(n);
        if (n == 0) {
            return;
        }
        this.state = new BitSet[n];
        this.visited = new BitSet(n);
        BitSet empty = new BitSet(n);
        this.search(0, JumboCyclicVertexSearch.copy(empty), JumboCyclicVertexSearch.copy(empty));
        int v = 0;
        while (this.visited.cardinality() != n) {
            if (this.visited.get(++v)) continue;
            this.search(v, JumboCyclicVertexSearch.copy(empty), JumboCyclicVertexSearch.copy(empty));
        }
        this.state = null;
        this.visited = null;
    }

    private void search(int v, BitSet prev, BitSet curr) {
        this.state[v] = curr;
        curr = JumboCyclicVertexSearch.copy(curr);
        curr.set(v);
        this.visited.or(curr);
        for (int w : this.g[v]) {
            if (prev.get(w)) {
                ++this.numCycles;
                this.add(JumboCyclicVertexSearch.xor(this.state[w], curr));
                continue;
            }
            if (this.visited.get(w)) continue;
            this.search(w, this.state[v], curr);
        }
    }

    @Override
    public int numCycles() {
        return this.numCycles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] vertexColor() {
        int[] result = this.colors;
        if (result == null) {
            JumboCyclicVertexSearch jumboCyclicVertexSearch = this;
            synchronized (jumboCyclicVertexSearch) {
                result = this.colors;
                if (result == null) {
                    this.colors = result = this.buildVertexColor();
                }
            }
        }
        return result;
    }

    private int[] buildVertexColor() {
        int[] color = new int[this.g.length];
        int n = 1;
        Arrays.fill(color, -1);
        for (BitSet cycle : this.cycles) {
            int i = cycle.nextSetBit(0);
            while (i >= 0) {
                color[i] = color[i] < 0 ? n : 0;
                i = cycle.nextSetBit(i + 1);
            }
            ++n;
        }
        return color;
    }

    @Override
    public boolean cyclic(int v) {
        return this.cyclic.get(v);
    }

    @Override
    public boolean cyclic(int u, int v) {
        int[] colors = this.vertexColor();
        if (colors[u] < 0 || colors[v] < 0) {
            return false;
        }
        if (colors[u] == 0 || colors[v] == 0) {
            for (BitSet cycle : this.cycles) {
                if (!cycle.get(u) || !cycle.get(v)) continue;
                return true;
            }
            return false;
        }
        return colors[u] == colors[v];
    }

    @Override
    public int[] cyclic() {
        return JumboCyclicVertexSearch.toArray(this.cyclic);
    }

    @Override
    public int[][] isolated() {
        ArrayList<int[]> isolated = new ArrayList<int[]>(this.cycles.size());
        for (int i = 0; i < this.cycles.size(); ++i) {
            if (this.fused.get(i).booleanValue()) continue;
            isolated.add(JumboCyclicVertexSearch.toArray(this.cycles.get(i)));
        }
        return (int[][])isolated.toArray((T[])new int[isolated.size()][]);
    }

    @Override
    public int[][] fused() {
        ArrayList<int[]> fused = new ArrayList<int[]>(this.cycles.size());
        for (int i = 0; i < this.cycles.size(); ++i) {
            if (!this.fused.get(i).booleanValue()) continue;
            fused.add(JumboCyclicVertexSearch.toArray(this.cycles.get(i)));
        }
        return (int[][])fused.toArray((T[])new int[fused.size()][]);
    }

    private void add(BitSet cycle) {
        BitSet intersect = JumboCyclicVertexSearch.and(cycle, this.cyclic);
        if (intersect.cardinality() > 1) {
            this.addFused(cycle);
        } else {
            this.addIsolated(cycle);
        }
        this.cyclic.or(cycle);
    }

    private void addIsolated(BitSet cycle) {
        this.cycles.add(cycle);
        this.fused.add(false);
    }

    private void addFused(BitSet cycle) {
        int i = this.indexOfFused(0, cycle);
        if (i != -1) {
            this.cycles.get(i).or(cycle);
            this.fused.set(i, true);
            int j = i;
            while ((j = this.indexOfFused(j + 1, cycle)) != -1) {
                this.cycles.get(i).or(this.cycles.remove(j));
                this.fused.remove(j);
                --j;
            }
        } else {
            this.addIsolated(cycle);
        }
    }

    private int indexOfFused(int start, BitSet cycle) {
        for (int i = start; i < this.cycles.size(); ++i) {
            if (JumboCyclicVertexSearch.and(this.cycles.get(i), cycle).cardinality() <= 1) continue;
            return i;
        }
        return -1;
    }

    static int[] toArray(BitSet set) {
        int[] vertices = new int[set.cardinality()];
        int i = 0;
        int v = 0;
        while (i < vertices.length) {
            if (set.get(v)) {
                vertices[i++] = v;
            }
            ++v;
        }
        return vertices;
    }

    static BitSet xor(BitSet x, BitSet y) {
        BitSet z = JumboCyclicVertexSearch.copy(x);
        z.xor(y);
        return z;
    }

    static BitSet and(BitSet x, BitSet y) {
        BitSet z = JumboCyclicVertexSearch.copy(x);
        z.and(y);
        return z;
    }

    static BitSet copy(BitSet org) {
        BitSet cpy = (BitSet)org.clone();
        return cpy;
    }
}

