/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.search;

import java.util.LinkedList;
import java.util.List;
import org.vikamine.kernel.subgroup.KBestSGSet;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.SGSets;
import org.vikamine.kernel.subgroup.search.SDMethod;
import org.vikamine.kernel.subgroup.search.SGGeneralizer;
import org.vikamine.kernel.subgroup.selectors.SGNominalSelector;

public class SDSimpleExhaustive
extends SDMethod {
    private boolean useInternalDisjunctions = false;
    private static final String NAME = "SDSimpleExhaustive";

    private List eliminateMeaningLessSelectorsWithAllAttributeValues(List sels) {
        LinkedList<SGNominalSelector> result = new LinkedList<SGNominalSelector>();
        for (SGNominalSelector sel : sels) {
            if (sel.isMaybeRedundant()) continue;
            result.add(sel);
        }
        return result;
    }

    private boolean containsInternalDisjunctios(List sels) {
        for (SGNominalSelector sel : sels) {
            if (sel.getValues().size() <= 1) continue;
            return true;
        }
        return false;
    }

    private List createSpecializedSubgroups(SG initialSubgroup) {
        List powerSetOfAttributeSpace = SGGeneralizer.computeAllGeneralizationsOfSelectorSets(this.selectorsCache);
        System.out.println("No. hypotheses " + powerSetOfAttributeSpace.size());
        LinkedList<SG> result = new LinkedList<SG>();
        for (List sels : powerSetOfAttributeSpace) {
            if (!this.useInternalDisjunctions && this.containsInternalDisjunctios(sels)) continue;
            sels = this.eliminateMeaningLessSelectorsWithAllAttributeValues(sels);
            SG newSG = (SG)initialSubgroup.clone();
            newSG.getSGDescription().addAll(sels);
            result.add(newSG);
        }
        return result;
    }

    @Override
    protected SGSet search(SG initialSubgroup) {
        if (this.task.getAttributes().size() > 15) {
            throw new IllegalArgumentException("SDSimpleExhaustive is only applicable for small sets of attributes to search, yet!");
        }
        KBestSGSet kBestSGSet = SGSets.createKBestSGSet(this.task.getMaxSGCount(), this.task.getMinQualityLimit());
        List subgroups = this.createSpecializedSubgroups(initialSubgroup);
        for (SG sg : subgroups) {
            if (kBestSGSet.contains(sg)) continue;
            sg.createStatistics(this.getOptions());
            sg.setQuality(this.task.getQualityFunction().evaluate(sg));
            if (!kBestSGSet.isInKBestQualityRange(sg.getQuality())) continue;
            kBestSGSet.addByReplacingWorstSG(sg);
        }
        return kBestSGSet;
    }

    @Override
    public String getName() {
        return NAME;
    }

    protected boolean isUseInternalDisjunctions() {
        return this.useInternalDisjunctions;
    }

    protected void setUseInternalDisjunctions(boolean useInternalDisjunctions) {
        this.useInternalDisjunctions = useInternalDisjunctions;
    }

    @Override
    public boolean isTreatMissingAsUndefinedSupported() {
        return true;
    }
}

